/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PossibleTypesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;

public final class OutlineNodeAddActionHandlerFactory
extends SapphireActionHandlerFactory {
    public static final String ID_BASE = "Sapphire.Add.";
    private Listener possibleTypesServiceListener;
    private Listener nodeFactoryListener;

    @Override
    public void init(SapphireAction action, ActionHandlerFactoryDef def) {
        super.init(action, def);
        this.possibleTypesServiceListener = new Listener(){

            public void handle(Event event) {
                OutlineNodeAddActionHandlerFactory.this.broadcast(new Event());
            }
        };
        this.nodeFactoryListener = new FilteredListener<PartVisibilityEvent>(){

            protected void handleTypedEvent(PartVisibilityEvent event) {
                OutlineNodeAddActionHandlerFactory.this.broadcast(new Event());
            }
        };
        final MasterDetailsContentNodePart node = (MasterDetailsContentNodePart)this.getPart();
        node.executeAfterInitialization(new Runnable(){

            @Override
            public void run() {
                for (MasterDetailsContentNodePart.NodeFactory factory : node.factories()) {
                    factory.attach(OutlineNodeAddActionHandlerFactory.this.nodeFactoryListener);
                    PossibleTypesService possibleTypesService = (PossibleTypesService)factory.property().service(PossibleTypesService.class);
                    possibleTypesService.attach(OutlineNodeAddActionHandlerFactory.this.possibleTypesServiceListener);
                }
                OutlineNodeAddActionHandlerFactory.this.broadcast(new Event());
            }
        });
    }

    @Override
    public List<SapphireActionHandler> create() {
        MasterDetailsContentNodePart node = (MasterDetailsContentNodePart)this.getPart();
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        for (MasterDetailsContentNodePart.NodeFactory factory : node.factories()) {
            Property property = factory.property();
            if (factory.visible() && !property.definition().isReadOnly()) {
                AbstractActionHandler handler;
                PossibleTypesService possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
                if (property instanceof ElementList) {
                    for (ElementType memberType : possibleTypesService.types()) {
                        handler = new ListPropertyActionHandler((ElementList)property, memberType);
                        handlers.add(handler);
                    }
                } else if (property instanceof ElementHandle && !(property.definition() instanceof ImpliedElementProperty)) {
                    for (ElementType memberType : possibleTypesService.types()) {
                        handler = new ElementPropertyActionHandler((ElementHandle)property, memberType);
                        handlers.add(handler);
                    }
                } else {
                    throw new IllegalStateException();
                }
            }
            Collections.sort(handlers, new Comparator<SapphireActionHandler>(){

                @Override
                public int compare(SapphireActionHandler x, SapphireActionHandler y) {
                    String xLabel = ((AbstractActionHandler)x).type().getLabel(true, CapitalizationType.NO_CAPS, false);
                    String yLabel = ((AbstractActionHandler)y).type().getLabel(true, CapitalizationType.NO_CAPS, false);
                    return xLabel.compareToIgnoreCase(yLabel);
                }
            });
        }
        return handlers;
    }

    @Override
    public void dispose() {
        super.dispose();
        MasterDetailsContentNodePart node = (MasterDetailsContentNodePart)this.getPart();
        for (MasterDetailsContentNodePart.NodeFactory factory : node.factories()) {
            factory.detach(this.nodeFactoryListener);
            Property property = factory.property();
            if (property.disposed()) continue;
            PossibleTypesService possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
            possibleTypesService.detach(this.possibleTypesServiceListener);
        }
    }

    private static abstract class AbstractActionHandler
    extends SapphireActionHandler {
        private final Property property;
        private final ElementType type;
        private MasterDetailsContentOutline contentTree;

        public AbstractActionHandler(Property property, ElementType type) {
            this.property = property;
            this.type = type;
        }

        @Override
        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            this.setId(OutlineNodeAddActionHandlerFactory.ID_BASE + this.type.getSimpleName());
            this.setLabel(this.type.getLabel(true, CapitalizationType.NO_CAPS, false));
            ImageData typeSpecificAddImage = this.type.image();
            if (typeSpecificAddImage != null) {
                this.addImage(typeSpecificAddImage);
            }
            this.contentTree = ((MasterDetailsContentNodePart)this.getPart()).getContentTree();
            final Listener contentTreeListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof MasterDetailsContentOutline.FilterChangedEvent) {
                        this.refreshEnablementState();
                    }
                }
            };
            this.contentTree.attach(contentTreeListener);
            this.refreshEnablementState();
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        contentTree.detach(contentTreeListener);
                    }
                }
            });
        }

        public final ElementType type() {
            return this.type;
        }

        protected final void refreshEnablementState() {
            this.setEnabled(this.computeEnablementState());
        }

        protected boolean computeEnablementState() {
            return this.contentTree != null && this.contentTree.getFilterText().length() == 0;
        }

        public Property property() {
            return this.property;
        }

        @Override
        protected final Object run(Presentation context) {
            Element newModelElement;
            MasterDetailsContentNodePart node;
            block4: {
                node = (MasterDetailsContentNodePart)this.getPart();
                newModelElement = null;
                try {
                    newModelElement = this.create(this.property, this.type);
                }
                catch (Exception e) {
                    EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                    if (editFailedException != null) break block4;
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
            if (newModelElement != null) {
                for (MasterDetailsContentNodePart n : node.nodes().visible()) {
                    if (n.getModelElement() != newModelElement) continue;
                    n.select();
                    this.getPart().nearest(MasterDetailsEditorPagePart.class).setFocusOnDetails();
                    break;
                }
            }
            return newModelElement;
        }

        protected abstract Element create(Property var1, ElementType var2);
    }

    private static final class ElementPropertyActionHandler
    extends AbstractActionHandler {
        public ElementPropertyActionHandler(ElementHandle<?> property, ElementType type) {
            super((Property)property, type);
        }

        @Override
        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            FilteredListener<PropertyEvent> listener = new FilteredListener<PropertyEvent>(){

                protected void handleTypedEvent(PropertyEvent event) {
                    this.refreshEnablementState();
                }
            };
            this.property().attach((Listener)listener);
            this.attach(new Listener((Listener)listener){
                private final /* synthetic */ Listener val$listener;
                {
                    this.val$listener = listener;
                }

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        this.property().detach(this.val$listener);
                    }
                }
            });
        }

        public ElementHandle<?> property() {
            return (ElementHandle)super.property();
        }

        @Override
        protected Element create(Property property, ElementType type) {
            return ((ElementHandle)property).content(true, type);
        }

        @Override
        protected boolean computeEnablementState() {
            boolean state = super.computeEnablementState();
            if (state) {
                state = this.property().content() == null;
            }
            return state;
        }
    }

    private static final class ListPropertyActionHandler
    extends AbstractActionHandler {
        public ListPropertyActionHandler(ElementList<?> property, ElementType type) {
            super((Property)property, type);
        }

        @Override
        protected Element create(Property property, ElementType type) {
            return ((ElementList)property).insert(type);
        }
    }
}

