/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.model;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class Language {
    private static final Pattern PATTERN = Pattern.compile("^[^_.]*(_([A-Za-z]{2}))?(_([A-Za-z]{2}))?(_([A-Za-z]{2}))?\\.properties$");
    public static final Language LANGUAGE_DEFAULT = new Language(new Locale("default"));
    public static final Language LANGUAGE_KEY = new Language(new Locale("key"));
    private boolean m_isLocal;
    private final Locale m_locale;

    public Language(Locale locale) {
        this.m_locale = (Locale)Validate.notNull((Object)locale);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getDispalyName() {
        if (this.m_locale == LANGUAGE_DEFAULT.getLocale()) {
            return "default";
        }
        return this.m_locale.getDisplayName();
    }

    public int hashCode() {
        return this.m_locale.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Language other = (Language)obj;
        return this.m_locale.equals(other.m_locale);
    }

    public String toString() {
        return this.getDispalyName();
    }

    public String getIsoCode() {
        return this.m_locale.toString();
    }

    public boolean isLocal() {
        return this.m_isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.m_isLocal = isLocal;
    }

    public static Language parse(String simpleFileName) {
        Matcher matcher = PATTERN.matcher(simpleFileName);
        if (matcher.matches()) {
            String variantIso;
            String countryIso;
            if (matcher.group(2) == null) {
                return LANGUAGE_DEFAULT;
            }
            String languageIso = matcher.group(2);
            if (languageIso == null) {
                languageIso = "";
            }
            if ((countryIso = matcher.group(4)) == null) {
                countryIso = "";
            }
            if ((variantIso = matcher.group(5)) == null) {
                variantIso = "";
            }
            return new Language(new Locale(languageIso, countryIso, variantIso));
        }
        return null;
    }
}

