/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.layoutoption;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.EnumLayoutValue;
import org.eclipse.sirius.diagram.description.EnumSetLayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithm;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractEditorDialogPropertySection;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.LayoutOptionPropertiesUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EnumSetLayoutOptionValuePropertySection
extends AbstractEditorDialogPropertySection {
    protected CLabel help;
    protected Button removeOverrideButton;
    private LayoutOption layoutOption;

    public EnumSetLayoutOptionValuePropertySection(LayoutOption layoutOption) {
        this.layoutOption = layoutOption;
    }

    protected String getDefaultLabelText() {
        return this.layoutOption.getLabel();
    }

    protected String getLabelText() {
        return this.layoutOption.getLabel();
    }

    protected EReference getFeature() {
        return DescriptionPackage.eINSTANCE.getEnumSetLayoutOption_Values();
    }

    protected String getFeatureAsText() {
        String string = new String();
        if (this.eObject instanceof EnumSetLayoutOption && this.eObject.eGet((EStructuralFeature)this.getFeature()) != null) {
            List values = (List)this.eObject.eGet((EStructuralFeature)this.getFeature());
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                EObject eObj = (EObject)iterator.next();
                string = String.valueOf(string) + this.getAdapterFactoryLabelProvider(eObj).getText((Object)eObj);
                if (!iterator.hasNext()) continue;
                string = String.valueOf(string) + ", ";
            }
        }
        return string;
    }

    protected boolean isEqual(List<?> newList) {
        return newList.equals(this.eObject.eGet((EStructuralFeature)this.getFeature()));
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.eObject = this.layoutOption;
        ((FormData)this.text.getLayoutData()).right = new FormAttachment(91, 0);
        ((FormData)this.button.getLayoutData()).left = new FormAttachment(91, 0);
        ((FormData)this.button.getLayoutData()).right = new FormAttachment(94, 0);
        this.removeOverrideButton = LayoutOptionPropertiesUtils.createRemoveOptionButton((Control)this.button, this.composite, (ViewpointPropertySheetPage)tabbedPropertySheetPage, this.getWidgetFactory(), this.layoutOption);
        this.help = LayoutOptionPropertiesUtils.createHelpLabel(this.getWidgetFactory(), this.composite, (Control)this.text, (Control)this.nameLabel, this.getHelpIcon(), this.layoutOption);
    }

    protected SelectionListener createButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List currentValues = (List)EnumSetLayoutOptionValuePropertySection.this.eObject.eGet((EStructuralFeature)EnumSetLayoutOptionValuePropertySection.this.getFeature());
                List<?> choiceOfValues = EnumSetLayoutOptionValuePropertySection.this.getChoiceOfValues(currentValues);
                FeatureEditorDialog dialog = new FeatureEditorDialog(EnumSetLayoutOptionValuePropertySection.this.composite.getShell(), (ILabelProvider)EnumSetLayoutOptionValuePropertySection.this.getAdapterFactoryLabelProvider(EnumSetLayoutOptionValuePropertySection.this.eObject), (Object)EnumSetLayoutOptionValuePropertySection.this.eObject, EnumSetLayoutOptionValuePropertySection.this.getFeature().getEType(), currentValues, EnumSetLayoutOptionValuePropertySection.this.layoutOption.getLabel(), choiceOfValues, false, false, choiceOfValues != null);
                dialog.open();
                EList result = dialog.getResult();
                if (result != null) {
                    EnumSetLayoutOptionValuePropertySection.this.handleFeatureModified((List)result);
                }
            }
        };
    }

    protected List<?> getChoiceOfValues(List<?> currentValues) {
        ArrayList<EnumLayoutValue> result = new ArrayList<EnumLayoutValue>();
        Map layoutProviderRegistry = DiagramUIPlugin.getPlugin().getLayoutAlgorithms();
        CustomLayoutConfiguration layout = (CustomLayoutConfiguration)this.layoutOption.eContainer();
        CustomLayoutAlgorithm genericLayoutProviderSupplier = (CustomLayoutAlgorithm)layoutProviderRegistry.get(layout.getId());
        Map layoutOptions = genericLayoutProviderSupplier.getLayoutOptions();
        EnumSetLayoutOption layoutOptionTemplate = (EnumSetLayoutOption)layoutOptions.get(this.layoutOption.getId());
        EList choices = layoutOptionTemplate.getChoices();
        EnumSetLayoutOption layoutOptionEnumSet = (EnumSetLayoutOption)this.layoutOption;
        for (EnumLayoutValue enumLayoutValue : choices) {
            Optional<EnumLayoutValue> alreadyExistingOption = layoutOptionEnumSet.getValues().stream().filter(value -> value.getName().equals(enumLayoutValue.getName())).findFirst();
            if (!alreadyExistingOption.isPresent()) {
                result.add((EnumLayoutValue)EcoreUtil.copy((EObject)enumLayoutValue));
                continue;
            }
            result.add(alreadyExistingOption.get());
        }
        return result;
    }

    public void dispose() {
        if (this.help != null) {
            this.help.dispose();
        }
        if (this.removeOverrideButton != null) {
            this.removeOverrideButton.dispose();
        }
        super.dispose();
    }
}

