/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.presentation;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.internal.migration.description.VSMExtendedMetaData;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.business.internal.migration.description.VSMResourceHandler;
import org.eclipse.sirius.business.internal.migration.description.VSMVersionSAXParser;
import org.eclipse.sirius.common.ui.tools.api.editor.IEObjectNavigable;
import org.eclipse.sirius.editor.Messages;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.properties.validation.SiriusInterpreterErrorDecorator;
import org.eclipse.sirius.editor.tools.internal.actions.ValidateAction;
import org.eclipse.sirius.editor.tools.internal.presentation.CustomSiriusAdapterFactoryLabelProvider;
import org.eclipse.sirius.editor.tools.internal.presentation.GeneratedElementsLabelProvider;
import org.eclipse.sirius.editor.tools.internal.presentation.ModificationTrackingEnabler;
import org.eclipse.sirius.editor.tools.internal.presentation.RepresentationTemplateUpdateTrigger;
import org.eclipse.sirius.editor.tools.internal.presentation.ValidationDecoration;
import org.eclipse.sirius.ui.business.api.template.RepresentationTemplateEditManager;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.util.DescriptionResourceImpl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Version;

public class CustomSiriusEditor
extends SiriusEditor
implements IEObjectNavigable {
    public static final String CONTEXT_ID = "org.eclipse.sirius.editor.siriusEditorContext";
    private static final ImageDescriptor EXPAND_IMAGE_DESCRIPTOR = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.editor", (String)"icons/full/expandall.gif");
    private static final ImageDescriptor COLLAPSE_IMAGE_DESCRIPTOR = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.editor", (String)"icons/full/collapseall.gif");
    private final RepresentationTemplateUpdateTrigger templateUpdateTrigger = new RepresentationTemplateUpdateTrigger();
    private final ViewpointURIHandler vsmURIHandler;
    private CommandStackListener cmdStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            CustomSiriusEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CustomSiriusEditor.this.isDirty()) {
                        ToolBarManager tbm = CustomSiriusEditor.this.getToolBarManager();
                        ValidateAction action = CustomSiriusEditor.this.getValidateAction(tbm);
                        action.setImageDescriptor(ValidateAction.HIGHLIGHT_DESC);
                        tbm.update(true);
                    }
                }
            });
        }
    };
    private GeneratedElementsLabelProvider decoratingLabelProvider;
    private ValidationDecoration validationDecorator;

    public CustomSiriusEditor() {
        this.editingDomain.getCommandStack().addCommandStackListener(this.cmdStackListener);
        this.editingDomain.getResourceSet().eAdapters().add((Object)new ECrossReferenceAdapter());
        this.editingDomain.getResourceSet().eAdapters().add((Object)new ModificationTrackingEnabler(this.editingDomain.getResourceSet()));
        this.vsmURIHandler = new ViewpointURIHandler(this.editingDomain.getResourceSet());
    }

    public Control getControl() {
        return this.getControl(0);
    }

    @Override
    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
        try {
            String uriAttribute;
            if ("org.eclipse.sirius.viewpointMarker".equals(marker.getType()) && (uriAttribute = marker.getAttribute("viewpointURIMarker", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException e) {
            SiriusEditorPlugin.INSTANCE.log((Object)e);
        }
        catch (WrappedException wrappedException) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean navigateToEObject(URI uri) {
        EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
        if (eObject != null) {
            this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
            return true;
        }
        return false;
    }

    @Override
    public void createPages() {
        super.createPages();
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(CONTEXT_ID);
        if (this.selectionViewer != null) {
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new CustomSiriusAdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory, (Viewer)this.selectionViewer));
            this.selectionViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !this.isEnvironmentResource(element) && !this.isMigrationAnnotation(element);
                }

                private boolean isEnvironmentResource(Object element) {
                    return element instanceof Resource && ((Resource)element).getURI() != null && "environment".equals(((Resource)element).getURI().scheme());
                }

                private boolean isMigrationAnnotation(Object element) {
                    return element instanceof DAnnotation && ((DAnnotation)element).eContainer() instanceof Group;
                }
            });
            this.validationDecorator = new ValidationDecoration();
            this.decoratingLabelProvider = new GeneratedElementsLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.selectionViewer.getLabelProvider(), (ILabelDecorator)this.validationDecorator);
            this.decoratingLabelProvider.setLabelDecorator(new SiriusInterpreterErrorDecorator(this.getURIFromInput(this.getEditorInput())));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)this.decoratingLabelProvider);
            this.selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = CustomSiriusEditor.this.selectionViewer.getSelection();
                    if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof EObject) {
                        EObject selectedEObject = (EObject)((StructuredSelection)selection).getFirstElement();
                        if (RepresentationTemplateEditManager.INSTANCE.isGenerated(selectedEObject)) {
                            EObject original = RepresentationTemplateEditManager.INSTANCE.getSourceElement(selectedEObject);
                            if (original != null) {
                                CustomSiriusEditor.this.setSelectionToViewer(Collections.singleton(CustomSiriusEditor.this.editingDomain.getWrapper((Object)original)));
                            }
                        } else if (selectedEObject instanceof JavaExtension) {
                            CustomSiriusEditor.this.navigateToJavaExtension((JavaExtension)selectedEObject);
                        }
                    }
                }
            });
            this.revealRepresentationDescriptions();
            ToolBarManager tbm = this.getToolBarManager();
            this.addTooBarActions(tbm);
            tbm.update(true);
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.templateUpdateTrigger);
    }

    private void navigateToJavaExtension(JavaExtension ext) {
        String className = ext.getQualifiedClassName();
        Optional<IJavaProject> enclosingJavaProject = this.getEnclosingJavaProject((EObject)ext);
        enclosingJavaProject.ifPresent(prj -> {
            try {
                IType serviceClass = prj.findType(className);
                if (serviceClass != null && serviceClass.exists()) {
                    JavaUI.openInEditor((IJavaElement)serviceClass);
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CustomSiriusEditor_failedNavigationTitle, (String)MessageFormat.format(Messages.CustomSiriusEditor_failedNavigationMessage, className));
                }
            }
            catch (JavaModelException | PartInitException e) {
                SiriusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.editor", e.getMessage(), e));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CustomSiriusEditor_failedNavigationTitle, (String)MessageFormat.format(Messages.CustomSiriusEditor_failedNavigationExceptionMessage, className));
            }
        });
    }

    private Optional<IJavaProject> getEnclosingJavaProject(EObject element) {
        Resource vsm = element.eResource();
        if (vsm.getURI().isPlatformResource()) {
            String projectName = vsm.getURI().segment(1);
            IProject rawProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (rawProject != null && rawProject.exists()) {
                return Optional.ofNullable(JavaCore.create((IProject)rawProject));
            }
        }
        return Optional.empty();
    }

    private void addTooBarActions(ToolBarManager tbm) {
        tbm.add((IAction)new Action(){

            public ImageDescriptor getImageDescriptor() {
                return EXPAND_IMAGE_DESCRIPTOR;
            }

            public String getToolTipText() {
                return "Expand All";
            }

            public String getId() {
                return "ExpandActionFromEditor";
            }

            public void run() {
                try {
                    CustomSiriusEditor.this.selectionViewer.getControl().setRedraw(false);
                    CustomSiriusEditor.this.selectionViewer.expandAll();
                }
                finally {
                    CustomSiriusEditor.this.selectionViewer.getControl().setRedraw(true);
                }
            }
        });
        tbm.add((IAction)new Action(){

            public ImageDescriptor getImageDescriptor() {
                return COLLAPSE_IMAGE_DESCRIPTOR;
            }

            public String getToolTipText() {
                return "Collapse All";
            }

            public String getId() {
                return "CollapseActionFromEditor";
            }

            public void run() {
                try {
                    CustomSiriusEditor.this.selectionViewer.getControl().setRedraw(false);
                    CustomSiriusEditor.this.selectionViewer.collapseToLevel(CustomSiriusEditor.this.selectionViewer.getInput(), -1);
                }
                finally {
                    CustomSiriusEditor.this.selectionViewer.getControl().setRedraw(true);
                }
            }
        });
        tbm.add((IAction)new ValidateAction(this.selectionViewer, this));
    }

    private void revealRepresentationDescriptions() {
        Optional<Group> group = this.getTopLevelGroup();
        if (group.isPresent()) {
            group.get().getOwnedViewpoints().stream().flatMap(v -> Stream.concat(v.getOwnedRepresentations().stream(), v.getOwnedRepresentationExtensions().stream())).forEach(arg_0 -> ((TreeViewer)this.selectionViewer).reveal(arg_0));
        }
    }

    private Optional<Group> getTopLevelGroup() {
        EObject root;
        Resource mainResource;
        EList roots;
        EList resources = this.editingDomain.getResourceSet().getResources();
        if (resources != null && !resources.isEmpty() && !(roots = (mainResource = (Resource)resources.get(0)).getContents()).isEmpty() && (root = (EObject)roots.get(0)) instanceof Group) {
            return Optional.of((Group)root);
        }
        return Optional.empty();
    }

    private ToolBarManager getToolBarManager() {
        return this.currentViewerPane.getToolBarManager();
    }

    private ValidateAction getValidateAction(ToolBarManager tbm) {
        IContributionItem[] contributions;
        IContributionItem[] iContributionItemArray = contributions = tbm.getItems();
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem contribution = iContributionItemArray[n2];
            if (contribution instanceof ActionContributionItem && "ValidateActionFromEditor".equals(contribution.getId()) && (action = ((ActionContributionItem)contribution).getAction()) instanceof ValidateAction) {
                return (ValidateAction)action;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void createModel() {
        URI resourceURI = this.getURIFromInput(this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    private URI getURIFromInput(IEditorInput input) {
        URI result = input == null ? null : (input instanceof IFileEditorInput ? URI.createPlatformResourceURI((String)((IFileEditorInput)this.getEditorInput()).getFile().getFullPath().toString(), (boolean)false) : (input instanceof URIEditorInput ? ((URIEditorInput)input).getURI() : (input instanceof IPathEditorInput ? URI.createFileURI((String)((IPathEditorInput)input).getPath().toOSString()) : (input instanceof IURIEditorInput ? URI.createURI((String)((IURIEditorInput)input).getURI().toString()) : (URI)input.getAdapter(URI.class)))));
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.editingDomain.getCommandStack().removeCommandStackListener(this.cmdStackListener);
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.templateUpdateTrigger);
        if (this.decoratingLabelProvider != null) {
            this.decoratingLabelProvider.dispose();
        }
    }

    @Override
    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : CustomSiriusEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !CustomSiriusEditor.this.isPersisted(resource) || CustomSiriusEditor.this.editingDomain.isReadOnly(resource) || resource.isTrackingModification() && !resource.isModified()) continue;
                    try {
                        CustomSiriusEditor.this.savedResources.add(resource);
                        if (resource instanceof XMLResource) {
                            ((XMLResource)resource).getDefaultSaveOptions().put("URI_HANDLER", CustomSiriusEditor.this.vsmURIHandler);
                        }
                        resource.save(Collections.emptyMap());
                    }
                    catch (Exception exception) {
                        CustomSiriusEditor.this.resourceToDiagnosticMap.put(resource, CustomSiriusEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            SiriusEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    @Override
    protected void beforeReload(Resource resource) {
        if (resource instanceof DescriptionResourceImpl) {
            VSMVersionSAXParser parser = new VSMVersionSAXParser(resource.getURI());
            String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
            boolean migrationIsNeeded = true;
            if (loadedVersion != null) {
                migrationIsNeeded = VSMMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)loadedVersion));
            }
            if (migrationIsNeeded) {
                VSMExtendedMetaData extendedMetaData = new VSMExtendedMetaData(loadedVersion);
                VSMResourceHandler resourceHandler = new VSMResourceHandler(loadedVersion);
                HashMap<String, Object> loadOptions = new HashMap<String, Object>();
                loadOptions.put("EXTENDED_META_DATA", extendedMetaData);
                loadOptions.put("RESOURCE_HANDLER", resourceHandler);
                ((DescriptionResourceImpl)resource).getDefaultLoadOptions().putAll(loadOptions);
                HashMap<String, Object> saveOptions = new HashMap<String, Object>();
                saveOptions.put("EXTENDED_META_DATA", extendedMetaData);
                saveOptions.put("RESOURCE_HANDLER", resourceHandler);
                ((DescriptionResourceImpl)resource).getDefaultSaveOptions().putAll(saveOptions);
            }
        }
    }

    private static class ViewpointURIHandler
    extends URIHandlerImpl.PlatformSchemeAware {
        private final ResourceSet resourceSet;

        ViewpointURIHandler(ResourceSet resourceSet) {
            this.resourceSet = (ResourceSet)Preconditions.checkNotNull((Object)resourceSet);
        }

        public URI deresolve(URI uri) {
            if (!this.baseURI.isPlatform() && "viewpoint".equals(this.baseURI.scheme())) {
                this.baseURI = this.resourceSet.getURIConverter().normalize(this.baseURI);
            }
            return super.deresolve(uri);
        }
    }
}

