/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator.filter;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.common.ui.tools.api.navigator.GroupingItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.CommonSessionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ProjectDependenciesItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ResourcesFolderItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointsFolderItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.eclipse.ui.navigator.CommonViewer;

public class PatternFilter
extends ViewerFilter {
    public static final String ID = "org.eclipse.sirius.ui.commonFilter.pattern";
    private static final Object[] EMPTY = new Object[0];
    private Map<Object, Object[]> cache = new HashMap<Object, Object[]>();
    private Map<Object, Boolean> foundAnyCache = new HashMap<Object, Boolean>();
    private boolean useCache;
    private boolean includeLeadingWildcard;
    private StringMatcher matcher;
    private boolean useEarlyReturnIfMatcherIsNull = true;

    public final Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result;
        if (this.matcher == null && this.useEarlyReturnIfMatcherIsNull) {
            result = elements;
        } else if (!this.useCache) {
            result = super.filter(viewer, parent, elements);
        } else {
            Object[] filtered = this.cache.get(parent);
            if (filtered == null) {
                Boolean foundAny = this.foundAnyCache.get(parent);
                filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
                this.cache.put(parent, filtered);
            }
            result = filtered;
        }
        return result;
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        boolean result;
        if (this.matcher == null) {
            result = true;
        } else if (!this.useCache) {
            result = this.computeAnyVisible(viewer, elements);
        } else {
            Object[] filtered = this.cache.get(parent);
            if (filtered != null) {
                result = filtered.length > 0;
            } else {
                Boolean foundAny = this.foundAnyCache.get(parent);
                if (foundAny == null) {
                    foundAny = this.computeAnyVisible(viewer, elements) ? Boolean.TRUE : Boolean.FALSE;
                    this.foundAnyCache.put(parent, foundAny);
                }
                result = foundAny;
            }
        }
        return result;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, element);
    }

    public final void setIncludeLeadingWildcard(boolean includeLeadingWildcard) {
        this.includeLeadingWildcard = includeLeadingWildcard;
    }

    public void setPattern(String patternString) {
        if ("org.eclipse.ui.keys.optimization.true".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (patternString == null || patternString.equals("")) {
            this.matcher = null;
        } else {
            String pattern = String.valueOf(patternString) + "*";
            if (this.includeLeadingWildcard) {
                pattern = "*" + pattern;
            }
            this.matcher = new StringMatcher(pattern, true, false);
        }
    }

    void clearCaches() {
        this.cache.clear();
        this.foundAnyCache.clear();
    }

    private boolean match(String string) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.match(string);
    }

    public boolean isElementSelectable(Object element) {
        return element != null;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        boolean result = this.matcher == null ? true : (this.isOnlySearchIn(element) ? this.isParentMatch(viewer, element) : (element instanceof RepresentationDescriptionItem ? this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element) && !this.isFilterWithEmptyDescription(viewer, (RepresentationDescriptionItem)element) : (element instanceof EObject || element instanceof CommonSessionItem || element instanceof ResourceFactoryImpl || element instanceof XMLResource ? this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element) : false)));
        return result;
    }

    private boolean isFilterWithEmptyDescription(Viewer viewer, RepresentationDescriptionItem element) {
        Object[] children;
        boolean isRepresentationDescriptionWithoutRepresentationFilterActive;
        boolean result = false;
        if (viewer instanceof CommonViewer && (isRepresentationDescriptionWithoutRepresentationFilterActive = ((CommonViewer)viewer).getNavigatorContentService().getFilterService().isActive("org.eclipse.sirius.ui.commonFilter.representation.description")) && ((children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren((Object)element)) == null || children.length == 0)) {
            result = true;
        }
        return result;
    }

    public boolean isOnlySearchIn(Object element) {
        boolean result = element instanceof IWorkingSet || element instanceof IProject || element instanceof IFolder || element instanceof IFile;
        result = result || element instanceof ViewpointsFolderItem || element instanceof ResourcesFolderItem || element instanceof ProjectDependenciesItem;
        result = result || element instanceof GroupingItem;
        return result;
    }

    protected boolean isParentMatch(Viewer viewer, Object element) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    private String[] getWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text);
        int i = iter.first();
        while (i != -1 && i < text.length()) {
            int j = iter.following(i);
            if (j == -1) {
                j = text.length();
            }
            if (Character.isLetterOrDigit(text.charAt(i))) {
                String word = text.substring(i, j);
                words.add(word);
            }
            i = j;
        }
        return words.toArray(new String[words.size()]);
    }

    protected boolean wordMatches(String text) {
        boolean result;
        if (text == null) {
            result = false;
        } else if (this.match(text)) {
            result = true;
        } else {
            String[] words = this.getWords(text);
            int i = 0;
            while (i < words.length) {
                String word = words[i];
                if (this.match(word)) {
                    result = true;
                }
                ++i;
            }
            result = false;
        }
        return result;
    }

    void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }
}

