/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.Map;
import org.eclipse.tcf.internal.debug.ui.model.ISymbolOwner;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFNodeSymbol
extends TCFNode {
    private final TCFNode.TCFData<ISymbols.Symbol> context;
    private final TCFNode.TCFData<String[]> children;
    private final TCFNode.TCFData<Map<String, Object>> location;
    private int update_policy;
    private ISymbolOwner owner;
    private TCFNodeSymbol prev;
    private TCFNodeSymbol next;
    private static final int MAX_SYMBOL_COUNT = 64;
    private static TCFNodeSymbol sym_list;
    private static int sym_count;
    private static boolean gc_posted;

    protected TCFNodeSymbol(TCFNode parent, final String id) {
        super(parent, id);
        this.context = new TCFNode.TCFData<ISymbols.Symbol>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                ISymbols syms = (ISymbols)TCFNodeSymbol.this.launch.getService(ISymbols.class);
                if (id == null || syms == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = syms.getContext(id, new ISymbols.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, ISymbols.Symbol sym) {
                        this.set(token, error, sym);
                        if (error != null || sym == null) {
                            TCFNodeSymbol.this.setUpdatePolicy(null, 0);
                        } else {
                            TCFNodeSymbol.this.setUpdatePolicy(sym.getOwnerID(), sym.getUpdatePolicy());
                        }
                    }
                });
                return false;
            }
        };
        this.children = new TCFNode.TCFData<String[]>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                ISymbols syms = (ISymbols)TCFNodeSymbol.this.launch.getService(ISymbols.class);
                if (id == null || syms == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = syms.getChildren(id, new ISymbols.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] ids) {
                        this.set(token, error, ids);
                    }
                });
                return false;
            }
        };
        this.location = new TCFNode.TCFData<Map<String, Object>>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                ISymbols syms = (ISymbols)TCFNodeSymbol.this.launch.getService(ISymbols.class);
                if (id == null || syms == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = syms.getLocationInfo(id, new ISymbols.DoneGetLocationInfo(){

                    public void doneGetLocationInfo(IToken token, Exception error, Map<String, Object> props) {
                        this.set(token, error, props);
                    }
                });
                return false;
            }
        };
        this.setUpdatePolicy(null, 0);
        if (sym_list == null) {
            this.prev = this.next = this;
        } else {
            this.prev = sym_list;
            this.next = TCFNodeSymbol.sym_list.next;
            this.prev.next = this.next.prev = this;
        }
        sym_list = this;
        if (!gc_posted) {
            gc_posted = true;
            Protocol.invokeLater((long)5000L, (Runnable)new Runnable(){

                @Override
                public void run() {
                    gc_posted = false;
                    int cnt = sym_count / 16;
                    while (sym_count > 64) {
                        TCFNodeSymbol s = sym_list.next;
                        if (s.context.isPending() || s.children.isPending()) break;
                        s.dispose();
                        if (cnt == 0) break;
                        --cnt;
                    }
                    if (sym_count > 0) {
                        gc_posted = true;
                        Protocol.invokeLater((long)5000L, (Runnable)this);
                    }
                }
            });
        }
        ++sym_count;
    }

    @Override
    public void dispose() {
        assert (!this.isDisposed());
        if (this.owner != null) {
            this.owner.removeSymbol(this);
            this.owner = null;
        }
        if (sym_list == this) {
            sym_list = this.prev;
        }
        if (sym_list == this) {
            sym_list = null;
        } else {
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }
        this.next = null;
        this.prev = null;
        assert (--sym_count == 0 == (sym_list == null));
        super.dispose();
    }

    private void moveUp() {
        if (sym_list != this) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = sym_list;
            this.next = TCFNodeSymbol.sym_list.next;
            this.prev.next = this.next.prev = this;
            sym_list = this;
        }
    }

    public TCFDataCache<ISymbols.Symbol> getContext() {
        this.moveUp();
        return this.context;
    }

    public TCFDataCache<String[]> getChildren() {
        this.moveUp();
        return this.children;
    }

    public TCFNode.TCFData<Map<String, Object>> getLocation() {
        this.moveUp();
        return this.location;
    }

    private void setUpdatePolicy(String id, int policy) {
        this.update_policy = policy;
        if (!this.isDisposed()) {
            TCFNode n = this.model.getNode(id);
            if (!(n instanceof ISymbolOwner)) {
                n = this.parent;
            }
            if (n != this.owner) {
                if (this.owner != null) {
                    this.owner.removeSymbol(this);
                }
                this.owner = (ISymbolOwner)((Object)n);
                this.owner.addSymbol(this);
            }
        }
    }

    void onMemoryMapChanged() {
        this.context.reset();
        this.children.reset();
        this.location.reset();
    }

    void onExeStateChange() {
        if (this.update_policy == 0) {
            return;
        }
        this.context.reset();
        this.children.reset();
        this.location.reset();
    }
}

