/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.connection.CVSCommunicationException;

public class Connection {
    private static final byte NEWLINE = 10;
    private IServerConnection serverConnection;
    private ICVSRepositoryLocation fCVSRoot;
    private boolean fIsEstablished;
    private InputStream fResponseStream;
    private String fServerEncoding;
    private byte[] readLineBuffer = new byte[256];

    public Connection(ICVSRepositoryLocation cvsroot, IServerConnection serverConnection) {
        this.fCVSRoot = cvsroot;
        this.serverConnection = serverConnection;
        this.fServerEncoding = Connection.getEncoding(this.fCVSRoot);
    }

    private static byte[] append(byte[] buffer, int index, byte b) {
        if (index >= buffer.length) {
            byte[] newBuffer = new byte[index * 2];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        buffer[index] = b;
        return buffer;
    }

    public void close() {
        if (!this.isEstablished()) {
            return;
        }
        try {
            try {
                this.serverConnection.close();
            }
            catch (IOException ex) {
                if (Policy.DEBUG) {
                    CVSProviderPlugin.log((CoreException)((Object)new CVSCommunicationException(CVSMessages.Connection_cannotClose, this.fCVSRoot, ex)));
                }
                this.fResponseStream = null;
                this.fIsEstablished = false;
            }
        }
        finally {
            this.fResponseStream = null;
            this.fIsEstablished = false;
        }
    }

    public void flush() throws CVSException {
        if (!this.isEstablished()) {
            return;
        }
        try {
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new CVSCommunicationException(this.fCVSRoot, e);
        }
    }

    public OutputStream getOutputStream() {
        if (!this.isEstablished()) {
            return null;
        }
        return this.serverConnection.getOutputStream();
    }

    public InputStream getInputStream() {
        if (!this.isEstablished()) {
            return null;
        }
        if (this.fResponseStream == null) {
            this.fResponseStream = this.serverConnection.getInputStream();
        }
        return this.fResponseStream;
    }

    public boolean isEstablished() {
        return this.fIsEstablished;
    }

    public void open(IProgressMonitor monitor) throws CVSException {
        if (this.isEstablished()) {
            return;
        }
        try {
            this.serverConnection.open(monitor);
        }
        catch (IOException e) {
            throw new CVSCommunicationException(NLS.bind((String)CVSMessages.Connection_0, (Object[])new String[]{this.fCVSRoot.getLocation(true), CVSCommunicationException.getMessageFor(e)}), this.fCVSRoot, e);
        }
        this.fIsEstablished = true;
    }

    public String readLine() throws CVSException {
        if (!this.isEstablished()) {
            throw new CVSCommunicationException(CVSMessages.Connection_readUnestablishedConnection, this.fCVSRoot, null);
        }
        try {
            int r;
            InputStream in = this.getInputStream();
            int index = 0;
            while ((r = in.read()) != -1) {
                if (r == 10) break;
                this.readLineBuffer = Connection.append(this.readLineBuffer, index++, (byte)r);
            }
            String result = new String(this.readLineBuffer, 0, index, this.fServerEncoding);
            if (Policy.isDebugProtocol()) {
                Policy.printProtocolLine(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new CVSCommunicationException(this.fCVSRoot, e);
        }
    }

    static String readLine(ICVSRepositoryLocation location, InputStream in) throws IOException {
        int r;
        byte[] buffer = new byte[256];
        int index = 0;
        while ((r = in.read()) != -1) {
            if (r == 10) break;
            buffer = Connection.append(buffer, index++, (byte)r);
        }
        String result = new String(buffer, 0, index, Connection.getEncoding(location));
        if (Policy.isDebugProtocol()) {
            Policy.printProtocolLine(result);
        }
        return result;
    }

    public void write(String s) throws CVSException {
        try {
            this.write(s.getBytes(this.fServerEncoding), false);
        }
        catch (UnsupportedEncodingException e) {
            CVSStatus status = new CVSStatus(4, -10, e.getMessage(), (Throwable)e, this.fCVSRoot);
            throw new CVSException((IStatus)status);
        }
    }

    public static String getEncoding(ICVSRepositoryLocation location) {
        return location.getEncoding();
    }

    public void writeLine(String s) throws CVSException {
        try {
            this.write(s.getBytes(this.fServerEncoding), true);
        }
        catch (UnsupportedEncodingException e) {
            CVSStatus status = new CVSStatus(4, -10, e.getMessage(), (Throwable)e, this.fCVSRoot);
            throw new CVSException((IStatus)status);
        }
    }

    void write(byte[] bytes, boolean newLine) throws CVSException {
        this.write(bytes, 0, bytes.length, newLine);
    }

    void write(byte[] b, int off, int len, boolean newline) throws CVSException {
        if (!this.isEstablished()) {
            throw new CVSCommunicationException(CVSMessages.Connection_writeUnestablishedConnection, this.fCVSRoot, null);
        }
        if (Policy.isDebugProtocol()) {
            Policy.printProtocol(new String(b, off, len), newline);
        }
        try {
            OutputStream out = this.getOutputStream();
            out.write(b, off, len);
            if (newline) {
                out.write(10);
            }
        }
        catch (IOException e) {
            throw new CVSCommunicationException(this.fCVSRoot, e);
        }
    }
}

