/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;

public class AddToBranchAction
extends CVSAction {
    IInputValidator validator = new IInputValidator(){

        public String isValid(String newText) {
            IStatus status = CVSTag.validateTagName((String)newText);
            if (status.isOK()) {
                return null;
            }
            return status.getMessage();
        }
    };

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                final ICVSRemoteFolder folder = AddToBranchAction.this.getSelectedRootFolder();
                if (folder == null) {
                    return;
                }
                Shell shell = AddToBranchAction.this.getShell();
                final CVSException[] exception = new CVSException[1];
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        InputDialog dialog = new InputDialog(AddToBranchAction.this.getShell(), CVSUIMessages.AddToBranchAction_enterTag, CVSUIMessages.AddToBranchAction_enterTagLong, null, (this).AddToBranchAction.this.validator);
                        if (dialog.open() == 0) {
                            CVSTag tag = new CVSTag(dialog.getValue(), 1);
                            try {
                                CVSUIPlugin.getPlugin().getRepositoryManager().addTags((ICVSResource)folder, new CVSTag[]{tag});
                            }
                            catch (CVSException e) {
                                exception[0] = e;
                            }
                        }
                    }
                });
                if (exception[0] != null) {
                    throw new InvocationTargetException(exception[0]);
                }
            }
        }, false, 2);
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedRootFolder() != null;
    }

    protected ICVSRemoteFolder getSelectedRootFolder() {
        ICVSRemoteFolder[] folders = this.getSelectedRemoteFolders();
        ICVSRemoteFolder selectedFolder = null;
        int i = 0;
        while (i < folders.length) {
            ICVSRemoteFolder folder = folders[i];
            if (folder.isDefinedModule() || new Path(null, folder.getRepositoryRelativePath()).segmentCount() == 1) {
                if (selectedFolder != null) {
                    return null;
                }
                selectedFolder = folder;
            }
            ++i;
        }
        return selectedFolder;
    }
}

