/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ccvs.ui.CVSDecoration;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceChangeSetCapability;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceModelParticipant;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipantLabelDecorator;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardCommitPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardFileTypePage;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class CommitWizardParticipant
extends WorkspaceModelParticipant {
    private WorkspaceChangeSetCapability capability;
    protected static final String ACTION_GROUP = "org.eclipse.tam.cvs.ui.CommitActions";
    final CommitWizard fWizard;
    protected Action showComparePaneAction;

    @Override
    public ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new WorkspaceChangeSetCapability(){

                @Override
                public boolean supportsCheckedInChangeSets() {
                    return false;
                }

                @Override
                public boolean enableActiveChangeSetsFor(ISynchronizePageConfiguration configuration) {
                    return false;
                }
            };
        }
        return this.capability;
    }

    public CommitWizardParticipant(SynchronizationContext context, CommitWizard wizard) {
        super(context);
        this.fWizard = wizard;
    }

    @Override
    protected ILabelDecorator getLabelDecorator(ISynchronizePageConfiguration configuration) {
        return new Decorator(configuration, this.fWizard);
    }

    @Override
    protected void initializeConfiguration(final ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.setProperty("org.eclipse.team.ui.P_TOOLBAR_MENU", (Object)new String[]{ACTION_GROUP, "navigate"});
        configuration.setProperty("org.eclipse.team.ui.P_CONTEXT_MENU", (Object)ISynchronizePageConfiguration.DEFAULT_CONTEXT_MENU);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "otherActions1");
        configuration.addActionContribution((SynchronizePageActionGroup)new ActionContribution());
        configuration.setRunnableContext(new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                CommitWizardParticipant.this.fWizard.getContainer().run(fork, cancelable, runnable);
                CommitWizardCommitPage page = CommitWizardParticipant.this.fWizard.getCommitPage();
                if (page != null) {
                    page.updateEnablements();
                }
            }
        });
        configuration.setSupportedModes(2);
        configuration.setMode(2);
        configuration.addActionContribution(new SynchronizePageActionGroup(){

            public void initialize(ISynchronizePageConfiguration configuration) {
                super.initialize(configuration);
                CommitWizardParticipant.this.showComparePaneAction = new Action(null, 2){

                    public void run() {
                        (this).CommitWizardParticipant.this.fWizard.getCommitPage().showComparePane(this.isChecked());
                    }
                };
                Utils.initAction((IAction)CommitWizardParticipant.this.showComparePaneAction, (String)"ComnitWizardComparePaneToggle.", (ResourceBundle)Policy.getActionBundle());
                CommitWizardParticipant.this.showComparePaneAction.setChecked(CommitWizardParticipant.this.isComparePaneVisible());
                this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", CommitWizardParticipant.ACTION_GROUP, (IAction)CommitWizardParticipant.this.showComparePaneAction);
            }
        });
        configuration.setProperty("org.eclipse.team.ui.P_OPEN_ACTION", (Object)new Action(){

            public void run() {
                ISelection selection = configuration.getSite().getSelectionProvider().getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)selection).getFirstElement();
                    if (CommitWizardParticipant.this.fWizard.getParticipant().hasCompareInputFor(obj)) {
                        CommitWizardParticipant.this.fWizard.getCommitPage().showComparePane(true);
                        CommitWizardParticipant.this.showComparePaneAction.setChecked(true);
                    }
                }
            }
        });
    }

    public boolean doesSupportSynchronize() {
        return false;
    }

    private boolean isComparePaneVisible() {
        IDialogSettings section = this.fWizard.getDialogSettings().getSection("CommitWizard");
        return section == null ? false : section.getBoolean("ShowCompare");
    }

    @Override
    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new WorkspaceModelParticipant.WorkspaceMergeActionGroup(this){

            @Override
            protected void addToContextMenu(String mergeActionId, Action action, IMenuManager manager) {
                if (mergeActionId == "org.eclipse.team.ui.mergeAction" || mergeActionId == "org.eclipse.team.ui.overwriteAction" || mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
                    return;
                }
                super.addToContextMenu(mergeActionId, action, manager);
            }

            protected void appendToGroup(String menuId, String groupId, IAction action) {
                if (menuId == "org.eclipse.team.ui.P_CONTEXT_MENU" && groupId == "commit") {
                    return;
                }
                super.appendToGroup(menuId, groupId, action);
            }
        };
    }

    private class ActionContribution
    extends SynchronizePageActionGroup {
        private ActionContribution() {
        }

        public void modelChanged(ISynchronizeModelElement root) {
            super.modelChanged(root);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CommitWizardCommitPage page = ((ActionContribution)ActionContribution.this).CommitWizardParticipant.this.fWizard.getCommitPage();
                    if (page != null) {
                        page.updateForModelChange();
                    }
                }
            });
        }
    }

    private static class Decorator
    extends CVSParticipantLabelDecorator {
        private final CommitWizard fWizard;

        public Decorator(ISynchronizePageConfiguration configuration, CommitWizard wizard) {
            super(configuration);
            this.fWizard = wizard;
        }

        @Override
        protected CVSDecoration getDecoration(IResource resource) throws CoreException {
            CVSDecoration decoration = super.getDecoration(resource);
            CommitWizardFileTypePage page = this.fWizard.getFileTypePage();
            if (page != null && resource instanceof IFile) {
                decoration.setKeywordSubstitution(page.getOption((IFile)resource).getShortDisplayText());
            }
            return decoration;
        }
    }
}

