/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.Filter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterExpressionCu;
import org.eclipse.tracecompass.tmf.filter.parser.FilterParserLexer;
import org.eclipse.tracecompass.tmf.filter.parser.FilterParserParser;

public class FilterCu {
    List<FilterExpressionCu> fExpressions;

    public FilterCu(List<FilterExpressionCu> expressions) {
        this.fExpressions = expressions;
    }

    protected List<FilterExpressionCu> getExpressions() {
        return this.fExpressions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FilterCu compile(String regex) {
        if (regex == null || regex.isEmpty()) {
            return null;
        }
        try {
            ANTLRStringStream stream = new ANTLRStringStream(regex);
            FilterParserLexer lexer = new FilterParserLexer((CharStream)stream);
            boolean[] invalid = new boolean[1];
            lexer.setErrorListener(e -> {
                boolean bl = e instanceof RecognitionException;
            });
            CommonTokenStream tokens = new CommonTokenStream();
            tokens.setTokenSource((TokenSource)lexer);
            FilterParserParser parser = new FilterParserParser((TokenStream)tokens);
            parser.setErrorListener(e -> {
                boolean bl = invalid[0] | e instanceof RecognitionException;
            });
            FilterParserParser.parse_return parse = parser.parse();
            if (invalid[0]) {
                return null;
            }
            CommonTree tree = parse.getTree();
            ArrayList<FilterExpressionCu> expressions = new ArrayList<FilterExpressionCu>();
            ArrayList<CommonTree> children = new ArrayList<CommonTree>();
            if (!tree.isNil()) {
                children.add(tree);
            } else {
                children.addAll(tree.getChildren());
            }
            Iterator iterator = children.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return new FilterCu(expressions);
                }
                CommonTree child = (CommonTree)iterator.next();
                FilterExpressionCu compile = FilterExpressionCu.compile(child);
                if (compile == null) {
                    return null;
                }
                expressions.add(compile);
            }
        }
        catch (RecognitionException recognitionException) {
            return null;
        }
    }

    public Predicate<Map<String, String>> generate() {
        Iterable expressions = Iterables.transform(this.fExpressions, exp -> exp.generate());
        return new Filter(expressions);
    }
}

