/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis.requirements;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfCompositeAnalysisRequirement
extends TmfAbstractAnalysisRequirement {
    private final Collection<TmfAbstractAnalysisRequirement> fSubReqs;

    public TmfCompositeAnalysisRequirement(Collection<TmfAbstractAnalysisRequirement> subRequirements, TmfAbstractAnalysisRequirement.PriorityLevel level) {
        super(Collections.EMPTY_SET, level);
        this.fSubReqs = ImmutableList.copyOf(subRequirements);
    }

    @Override
    public boolean test(ITmfTrace trace) {
        Collection<TmfAbstractAnalysisRequirement> subReqs = this.fSubReqs;
        if (subReqs.isEmpty()) {
            return true;
        }
        long count = subReqs.stream().filter(r -> r.test(trace)).count();
        switch (this.getPriorityLevel()) {
            case ALL_OR_NOTHING: {
                return count == (long)subReqs.size() || count == 0L;
            }
            case AT_LEAST_ONE: {
                return count > 0L;
            }
            case MANDATORY: {
                return count == (long)subReqs.size();
            }
            case OPTIONAL: {
                return true;
            }
        }
        throw new IllegalStateException("Composite requirement: Unknown value level");
    }
}

