/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.AbstractIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.IIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;

public class DisjointUnionTable
extends AbstractIndexTable {
    protected List<IIndexTable> childTables = CollectionsFactory.createObserverList();

    public DisjointUnionTable(IInputKey inputKey, ITableContext tableContext) {
        super(inputKey, tableContext);
    }

    public List<IIndexTable> getChildTables() {
        return Collections.unmodifiableList(this.childTables);
    }

    public void addChildTable(IIndexTable child) {
        if (this.getInputKey().getArity() != child.getInputKey().getArity()) {
            throw new IllegalArgumentException(child.toString());
        }
        this.childTables.add(child);
    }

    @Override
    public int countTuples(TupleMask seedMask, ITuple seed) {
        int count2 = 0;
        for (IIndexTable child : this.childTables) {
            count2 += child.countTuples(seedMask, seed);
        }
        return count2;
    }

    @Override
    public Iterable<Tuple> enumerateTuples(TupleMask seedMask, ITuple seed) {
        return () -> {
            Stream<Object> stream = Stream.empty();
            for (IIndexTable child : this.childTables) {
                Iterable<Tuple> childResult = child.enumerateTuples(seedMask, seed);
                stream = Stream.concat(stream, StreamSupport.stream(childResult.spliterator(), false));
            }
            return stream.iterator();
        };
    }

    @Override
    public Iterable<? extends Object> enumerateValues(TupleMask seedMask, ITuple seed) {
        return () -> {
            Stream<Object> stream = Stream.empty();
            for (IIndexTable child : this.childTables) {
                Iterable<? extends Object> childResult = child.enumerateValues(seedMask, seed);
                stream = Stream.concat(stream, StreamSupport.stream(childResult.spliterator(), false));
            }
            return stream.iterator();
        };
    }

    @Override
    public boolean containsTuple(ITuple seed) {
        for (IIndexTable child : this.childTables) {
            if (!child.containsTuple(seed)) continue;
            return true;
        }
        return false;
    }
}

