/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;

public class LoadQueriesHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "org.eclipse.viatra.query.tooling.ui.result.loadqueries";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IViewPart resultView = HandlerUtil.getActiveSite((ExecutionEvent)event).getPage().findView("org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView");
        if (resultView instanceof QueryResultView) {
            QueryResultView queryResultView = (QueryResultView)resultView;
            boolean active = queryResultView.hasActiveEngine();
            if (active && selection instanceof IStructuredSelection) {
                Set<QueryRegistryTreeEntry> selectedQueries = QueryResultViewUtil.getRegistryEntriesFromSelection((IStructuredSelection)selection);
                queryResultView.loadQueriesIntoActiveEngineInBackground(selectedQueries);
            } else {
                LoadQueriesHandler.queryLoadingFailed(queryResultView.getSite().getShell());
            }
        }
        return null;
    }

    public static void queryLoadingFailed(Shell parent) {
        MessageDialog.openError((Shell)parent, (String)"Query loading failed", (String)"Please load a model into the Query Results view before loading queries!");
    }
}

