/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import java.text.MessageFormat;
import org.eclipse.wb.internal.swt.model.ModelMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FormSide {
    LEFT{

        public String getField() {
            return "left";
        }

        public int getFormSide() {
            return 16384;
        }

        public int getEngineSide() {
            return 1;
        }

        public FormSide getOppositeSide() {
            return RIGHT;
        }
    }
    ,
    RIGHT{

        public String getField() {
            return "right";
        }

        public int getFormSide() {
            return 131072;
        }

        public int getEngineSide() {
            return 4;
        }

        public FormSide getOppositeSide() {
            return LEFT;
        }
    }
    ,
    TOP{

        public String getField() {
            return "top";
        }

        public int getFormSide() {
            return 128;
        }

        public int getEngineSide() {
            return 8;
        }

        public FormSide getOppositeSide() {
            return BOTTOM;
        }
    }
    ,
    BOTTOM{

        public String getField() {
            return "bottom";
        }

        public int getFormSide() {
            return 1024;
        }

        public int getEngineSide() {
            return 32;
        }

        public FormSide getOppositeSide() {
            return TOP;
        }
    };


    private FormSide() {
    }

    public abstract String getField();

    public abstract int getFormSide();

    public abstract int getEngineSide();

    public abstract FormSide getOppositeSide();

    public static FormSide get(int side) {
        if (side == 1) {
            return LEFT;
        }
        if (side == 4) {
            return RIGHT;
        }
        if (side == 8) {
            return TOP;
        }
        if (side == 32) {
            return BOTTOM;
        }
        throw new Error(MessageFormat.format(ModelMessages.FormSide_unknownSize, side));
    }

    /* synthetic */ FormSide(String string, int n, FormSide formSide) {
        this();
    }
}

