/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.adapters;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory2;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.core.model.IScriptGroup;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.adapters.JavaScriptAsyncContentProvider;
import org.eclipse.wst.jsdt.debug.internal.ui.adapters.JavaScriptModelProxyFactory;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.ToggleBreakpointAdapter;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.RunToLineAdapter;

public class JavaScriptAdapterFactory
implements IAdapterFactory {
    static IWorkbenchAdapter wadapter = null;
    static ToggleBreakpointAdapter tbadapter = null;
    static JavaScriptAsyncContentProvider jscontent = null;
    static JavaScriptModelProxyFactory jsproxyfactory = null;
    static RunToLineAdapter runtoline = null;

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType.equals(IToggleBreakpointsTarget.class)) {
            return JavaScriptAdapterFactory.getToggleBreakpointAdapter();
        }
        if (adapterType.equals(IWorkbenchAdapter.class) && adaptableObject instanceof IJavaScriptBreakpoint) {
            return this.getWorkbenchAdapter();
        }
        if (adapterType.equals(IRunToLineTarget.class)) {
            return this.getRunToLine();
        }
        if (adapterType.equals(IElementContentProvider.class) && (adaptableObject instanceof IJavaScriptDebugTarget || adaptableObject instanceof IScriptGroup)) {
            return this.getJSContentProvider();
        }
        if (adapterType.equals(IModelProxyFactory2.class)) {
            return this.getJSProxyFactory();
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IToggleBreakpointsTarget.class, IWorkbenchAdapter.class, IRunToLineTarget.class, IElementContentProvider.class, IModelProxyFactory2.class};
    }

    synchronized RunToLineAdapter getRunToLine() {
        if (runtoline == null) {
            runtoline = new RunToLineAdapter();
        }
        return runtoline;
    }

    synchronized JavaScriptModelProxyFactory getJSProxyFactory() {
        if (jsproxyfactory == null) {
            jsproxyfactory = new JavaScriptModelProxyFactory();
        }
        return jsproxyfactory;
    }

    synchronized JavaScriptAsyncContentProvider getJSContentProvider() {
        if (jscontent == null) {
            jscontent = new JavaScriptAsyncContentProvider();
        }
        return jscontent;
    }

    synchronized IWorkbenchAdapter getWorkbenchAdapter() {
        if (wadapter == null) {
            wadapter = new WorkbenchAdapter();
        }
        return wadapter;
    }

    public static synchronized ToggleBreakpointAdapter getToggleBreakpointAdapter() {
        if (tbadapter == null) {
            tbadapter = new ToggleBreakpointAdapter();
        }
        return tbadapter;
    }

    class WorkbenchAdapter
    implements IWorkbenchAdapter {
        WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            if (o instanceof IJavaScriptBreakpoint) {
                try {
                    return ((IJavaScriptBreakpoint)o).getScriptPath();
                }
                catch (CoreException ce) {
                    JavaScriptDebugUIPlugin.log(ce);
                }
            }
            return null;
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

