/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.RuntimeTypeWithServerProxy;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class RuntimeTypeTreeContentProvider
extends AbstractTreeContentProvider {
    protected boolean creation;
    protected String type;
    protected String version;
    protected String runtimeTypeId;
    List<IRuntimeType> runtimeInstalledList;

    public RuntimeTypeTreeContentProvider(boolean creation) {
        this.creation = creation;
    }

    public RuntimeTypeTreeContentProvider(boolean creation, String type, String version, String runtimeTypeId) {
        super(false);
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
        this.creation = creation;
        this.fillTree();
    }

    public void fillTree() {
        this.clean();
        this.runtimeInstalledList = new ArrayList<IRuntimeType>();
        ArrayList<AbstractTreeContentProvider.TreeElement> list = new ArrayList<AbstractTreeContentProvider.TreeElement>();
        IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes((String)this.type, (String)this.version, (String)this.runtimeTypeId);
        if (runtimeTypes != null) {
            int size = runtimeTypes.length;
            int i = 0;
            while (i < size) {
                block6: {
                    IRuntimeType runtimeType = runtimeTypes[i];
                    if (!this.creation || runtimeType.canCreate()) {
                        block5: {
                            try {
                                if (((RuntimeType)runtimeType).supportsManualCreation()) break block5;
                                break block6;
                            }
                            catch (Exception exception) {}
                        }
                        AbstractTreeContentProvider.TreeElement ele = this.getOrCreate(list, runtimeType.getVendor());
                        ele.contents.add(runtimeType);
                        this.elementToParentMap.put(runtimeType, ele);
                        this.runtimeInstalledList.add(runtimeType);
                    }
                }
                ++i;
            }
        }
        this.elements = list.toArray();
    }

    protected void deferredAdapterInitialize(final TreeViewer treeViewer, IProgressMonitor monitor) {
        ArrayList<AbstractTreeContentProvider.TreeElement> list = new ArrayList<AbstractTreeContentProvider.TreeElement>();
        IRuntimeType[] runtimeTypes = ServerCore.getDownloadableRuntimeTypes((IProgressMonitor)monitor);
        if (runtimeTypes != null) {
            int size = runtimeTypes.length;
            int i = 0;
            while (i < size) {
                block10: {
                    IRuntimeType runtimeType;
                    block9: {
                        runtimeType = runtimeTypes[i];
                        try {
                            if (((RuntimeType)runtimeType).supportsManualCreation()) break block9;
                            break block10;
                        }
                        catch (Exception exception) {}
                    }
                    AbstractTreeContentProvider.TreeElement ele = this.getOrCreate(list, runtimeType.getVendor());
                    if (!this.compareRuntimes(ele.contents, (RuntimeTypeWithServerProxy)runtimeType)) {
                        if (!this.compareRuntimes(this.runtimeInstalledList, (RuntimeTypeWithServerProxy)runtimeType)) {
                            ele.contents.add(runtimeType);
                            this.elementToParentMap.put(runtimeType, ele);
                        } else if (ele.contents.isEmpty()) {
                            list.remove(ele);
                            this.elementToParentMap.remove(ele);
                        }
                    }
                }
                ++i;
            }
        }
        if (list.size() > 0) {
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.addAll(Arrays.asList(this.elements));
            newList.addAll(list);
            this.elements = newList.toArray();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!treeViewer.getTree().isDisposed()) {
                        treeViewer.refresh((Object)"root");
                    }
                }
            });
        }
    }

    private boolean compareRuntimes(List runtimeList, RuntimeTypeWithServerProxy runtimeType) {
        for (IRuntimeType existingRuntime : runtimeList) {
            if (!existingRuntime.getId().equals(runtimeType.getProxyRuntimeId())) continue;
            if (Trace.INFO) {
                Trace.trace("/info", "already installed: " + runtimeType.getProxyRuntimeId(), null);
            }
            return true;
        }
        return false;
    }
}

