/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIExceptionHandler;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UpdateAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.IdentifierBag;
import org.uddi4j.util.KeyedReference;

public class UpdateServiceInterfaceAction
extends UpdateAction {
    private boolean isUpdate_ = true;

    public UpdateServiceInterfaceAction(Controller controller) {
        super(controller, true);
    }

    protected boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        boolean isModified;
        boolean isModified2;
        String uuidKey = parser.getParameter("uuidServiceInterfaceKey");
        String wsdlURLModifiedState = parser.getParameter("wsdlURLModified");
        String wsdlURL = parser.getParameter("advancedServiceInterfaceWSDLURL");
        String nameModifiedState = parser.getParameter("nameModified");
        String name = parser.getParameter("advancedServiceInterfaceName");
        String[] descriptionModifiedStates = parser.getParameterValues("descriptionModified");
        String[] descriptionViewIds = parser.getParameterValues("descriptionViewId");
        String[] descriptionLanguages = parser.getParameterValues("advancedDescriptionLanguage");
        String[] descriptions = parser.getParameterValues("advancedDescription");
        String[] idModifiedStates = parser.getParameterValues("identifierModified");
        String[] idViewIds = parser.getParameterValues("identifierViewId");
        String[] idTypes = parser.getParameterValues("advancedIdentifierType");
        String[] idKeyNames = parser.getParameterValues("advancedIdentifierKeyName");
        String[] idKeyValues = parser.getParameterValues("advancedIdentifierKeyValue");
        String[] catModifiedStates = parser.getParameterValues("categoryModified");
        String[] catViewIds = parser.getParameterValues("categoryViewId");
        String[] catTypes = parser.getParameterValues("advancedCategoryType");
        String[] catKeyNames = parser.getParameterValues("advancedCategoryKeyName");
        String[] catKeyValues = parser.getParameterValues("advancedCategoryKeyValue");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (uuidKey != null) {
            this.propertyTable_.put("uuidServiceInterfaceKey", uuidKey);
        }
        if (wsdlURLModifiedState != null && wsdlURL != null) {
            ListElement wsdlURLListElement = (ListElement)formToolPI.getProperty("advancedServiceInterfaceWSDLURL");
            isModified2 = Boolean.valueOf(wsdlURLModifiedState);
            if (isModified2) {
                wsdlURLListElement = new ListElement(wsdlURL);
            } else {
                wsdlURL = (String)wsdlURLListElement.getObject();
            }
            this.propertyTable_.put("advancedServiceInterfaceWSDLURL", wsdlURLListElement);
            if (!Validator.validateURL(wsdlURL)) {
                inputsValid = false;
                formToolPI.flagError("advancedServiceInterfaceWSDLURL");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_WSDL_URL"));
            }
        } else {
            this.removeProperty("advancedServiceInterfaceWSDLURL");
        }
        if (nameModifiedState != null && name != null) {
            ListElement nameListElement = (ListElement)formToolPI.getProperty("advancedServiceInterfaceName");
            isModified2 = Boolean.valueOf(nameModifiedState);
            if (isModified2) {
                nameListElement = new ListElement(name);
            } else {
                name = (String)nameListElement.getObject();
            }
            this.propertyTable_.put("advancedServiceInterfaceName", nameListElement);
            if (!Validator.validateString(name)) {
                inputsValid = false;
                formToolPI.flagError("advancedServiceInterfaceName");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_NAME"));
            }
        } else {
            this.removeProperty("advancedServiceInterfaceName");
        }
        Hashtable<String, Boolean> languageHash = new Hashtable<String, Boolean>();
        if (descriptionModifiedStates != null && descriptionViewIds != null && descriptionLanguages != null && descriptions != null) {
            Vector oldDescriptionListElementVector = (Vector)formToolPI.getProperty("advancedServiceInterfaceDescriptions");
            Vector<ListElement> newDescriptionListElementVector = new Vector<ListElement>();
            String[] parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_DESCRIPTION");
            languageHash.clear();
            int i = 0;
            while (i < descriptions.length) {
                Description uddi4jDescription;
                parameters[1] = String.valueOf(i + 1);
                if (descriptionLanguages[i].length() > 0) {
                    uddi4jDescription = new Description(descriptions[i], descriptionLanguages[i]);
                } else {
                    uddi4jDescription = new Description(descriptions[i]);
                    if (i != 0) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedServiceInterfaceDescriptions", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(descriptionLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceInterfaceDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(descriptionLanguages[i], Boolean.TRUE);
                }
                if (!Validator.validateString(descriptions[i])) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedServiceInterfaceDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                int descriptionViewId = Integer.parseInt(descriptionViewIds[i]);
                boolean isModified3 = Boolean.valueOf(descriptionModifiedStates[i]);
                if (descriptionViewId == -1 || isModified3) {
                    newDescriptionListElementVector.addElement(new ListElement(uddi4jDescription));
                } else {
                    newDescriptionListElementVector.addElement((ListElement)oldDescriptionListElementVector.elementAt(descriptionViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newDescriptionListElementVector);
            this.propertyTable_.put("advancedServiceInterfaceDescriptions", newDescriptionListElementVector);
        } else {
            this.removeProperty("advancedServiceInterfaceDescriptions");
        }
        if (idModifiedStates != null && idViewIds != null && idTypes != null && idKeyNames != null && idKeyValues != null) {
            Vector oldIdListElementVector = (Vector)formToolPI.getProperty("advancedServiceInterfaceIdentifiers");
            Vector<ListElement> newIdListElementVector = new Vector<ListElement>();
            int i = 0;
            while (i < idKeyNames.length) {
                KeyedReference kr = new KeyedReference(idKeyNames[i], idKeyValues[i], idTypes[i]);
                int idViewId = Integer.parseInt(idViewIds[i]);
                isModified = Boolean.valueOf(idModifiedStates[i]);
                if (idViewId == -1 || isModified) {
                    newIdListElementVector.addElement(new ListElement(kr));
                } else {
                    newIdListElementVector.addElement((ListElement)oldIdListElementVector.elementAt(idViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newIdListElementVector);
            this.propertyTable_.put("advancedServiceInterfaceIdentifiers", newIdListElementVector);
        } else {
            this.removeProperty("advancedServiceInterfaceIdentifiers");
        }
        if (catModifiedStates != null && catViewIds != null && catTypes != null && catKeyNames != null && catKeyValues != null) {
            Vector oldCatListElementVector = (Vector)formToolPI.getProperty("advancedServiceInterfaceCategories");
            Vector<ListElement> newCatListElementVector = new Vector<ListElement>();
            int i = 0;
            while (i < catTypes.length) {
                KeyedReference kr = new KeyedReference(catKeyNames[i], catKeyValues[i], catTypes[i]);
                int catViewId = Integer.parseInt(catViewIds[i]);
                isModified = Boolean.valueOf(catModifiedStates[i]);
                if (catViewId == -1 || isModified) {
                    newCatListElementVector.addElement(new ListElement(kr));
                } else {
                    newCatListElementVector.addElement((ListElement)oldCatListElementVector.elementAt(catViewId));
                }
                ++i;
            }
            this.reindexListElementVector(newCatListElementVector);
            this.propertyTable_.put("advancedServiceInterfaceCategories", newCatListElementVector);
        } else {
            this.removeProperty("advancedServiceInterfaceCategories");
        }
        return inputsValid;
    }

    public final boolean refreshFromRegistry() {
        this.controller_.getUDDIPerspective();
        try {
            String uuidKey = (String)this.propertyTable_.get("uuidServiceInterfaceKey");
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            UDDIProxy proxy = regElement.getProxy();
            TModelDetail tModelDetail = proxy.get_tModelDetail(uuidKey);
            Vector tModelVector = tModelDetail.getTModelVector();
            if (tModelVector.size() > 0) {
                this.propertyTable_.put("latestObject", tModelVector.elementAt(0));
                return true;
            }
        }
        catch (UDDIException uDDIException) {
        }
        catch (TransportException transportException) {}
        this.isUpdate_ = false;
        return false;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            String uuidKey = (String)this.propertyTable_.get("uuidServiceInterfaceKey");
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            ListElement wsdlURLListElement = (ListElement)this.propertyTable_.get("advancedServiceInterfaceWSDLURL");
            ListElement nameListElement = (ListElement)this.propertyTable_.get("advancedServiceInterfaceName");
            Vector descriptionListElementVector = (Vector)this.propertyTable_.get("advancedServiceInterfaceDescriptions");
            Vector idListElementVector = (Vector)this.propertyTable_.get("advancedServiceInterfaceIdentifiers");
            Vector catListElementVector = (Vector)this.propertyTable_.get("advancedServiceInterfaceCategories");
            String wsdlURL = (String)wsdlURLListElement.getObject();
            String name = (String)nameListElement.getObject();
            Vector<Description> descriptionVector = null;
            if (descriptionListElementVector != null) {
                descriptionVector = new Vector<Description>();
                int i = 0;
                while (i < descriptionListElementVector.size()) {
                    ListElement listElement = (ListElement)descriptionListElementVector.elementAt(i);
                    Description description = (Description)listElement.getObject();
                    descriptionVector.addElement(description);
                    ++i;
                }
            }
            IdentifierBag idBag = null;
            if (idListElementVector != null) {
                idBag = new IdentifierBag();
                int i = 0;
                while (i < idListElementVector.size()) {
                    ListElement listElement = (ListElement)idListElementVector.elementAt(i);
                    KeyedReference kr = (KeyedReference)listElement.getObject();
                    idBag.add(kr);
                    ++i;
                }
            }
            CategoryBag catBag = null;
            if (catListElementVector != null) {
                catBag = new CategoryBag();
                int i = 0;
                while (i < catListElementVector.size()) {
                    ListElement listElement = (ListElement)catListElementVector.elementAt(i);
                    KeyedReference kr = (KeyedReference)listElement.getObject();
                    catBag.add(kr);
                    ++i;
                }
            }
            TModel tModel = new Uddi4jHelper().newTModel(wsdlURL);
            if (this.isUpdate_) {
                tModel.setTModelKey(uuidKey);
            }
            tModel.setName(name);
            tModel.setDescriptionVector(descriptionVector);
            tModel.setIdentifierBag(idBag);
            tModel.setCategoryBag(catBag);
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            UDDIProxy proxy = regElement.getProxy();
            Vector<TModel> tModelVector = new Vector<TModel>();
            tModelVector.add(tModel);
            tModel = (TModel)proxy.save_tModel(regElement.getAuthInfoString(), tModelVector).getTModelVector().get(0);
            this.refreshNode(tModel);
            if (this.isUpdate_) {
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_INTERFACE_UPDATED", tModel.getNameString()));
            } else {
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICE_INTERFACE_PUBLISHED", tModel.getNameString()));
            }
            return true;
        }
        catch (WSDLException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "WSDLException", e);
        }
        catch (TransportException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
        }
        catch (UDDIException e) {
            if (UDDIExceptionHandler.requiresReset(e)) {
                RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
                regElement.setDefaults();
            }
            messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "MalformedURLException", e);
        }
        return false;
    }
}

