/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.export.excel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.export.excel.ExcelExportProgessBar;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.print.command.TurnViewportOnCommand;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.CellStyleProxy;
import net.sourceforge.nattable.util.IClientAreaProvider;
import net.sourceforge.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class ExcelExporter {
    private static final Object DEFAULT = "";
    private static final String EXCEL_HEADER_FILE = "excelExportHeader.txt";
    private final ILayer layer;
    private final IConfigRegistry configRegistry;
    private final IClientAreaProvider originalClientAreaProvider;

    public ExcelExporter(ILayer layer, IConfigRegistry configRegistry) {
        this.layer = layer;
        this.configRegistry = configRegistry;
        this.originalClientAreaProvider = layer.getClientAreaProvider();
    }

    public void export(Shell shell, final OutputStream outputStream, final Rectangle positionRectangle) throws IOException {
        final ExcelExportProgessBar progressBar = new ExcelExportProgessBar(shell);
        Runnable exporter = new Runnable(){

            public void run() {
                try {
                    try {
                        int startRow = positionRectangle.y;
                        int endRow = startRow + positionRectangle.height;
                        progressBar.open(startRow, endRow);
                        ExcelExporter.this.writeHeader(outputStream);
                        outputStream.write(ExcelExporter.this.asBytes("<body><table border='1'>"));
                        int rowPosition = startRow;
                        while (rowPosition <= endRow) {
                            progressBar.setSelection(rowPosition);
                            outputStream.write(ExcelExporter.this.asBytes("<tr>\n"));
                            int startColumn = positionRectangle.x;
                            int endColumn = startColumn + positionRectangle.width;
                            int colPosition = startColumn;
                            while (colPosition <= endColumn) {
                                LayerCell cell = ExcelExporter.this.layer.getCellByPosition(colPosition, rowPosition);
                                outputStream.write(ExcelExporter.this.asBytes("\t" + ExcelExporter.this.getCellAsHTML(cell) + "\n"));
                                ++colPosition;
                            }
                            outputStream.write(ExcelExporter.this.asBytes("</tr>\n"));
                            ++rowPosition;
                        }
                        outputStream.write(ExcelExporter.this.asBytes("</table></body></html>"));
                    }
                    catch (Exception e) {
                        ExcelExporter.this.logError(e);
                        try {
                            outputStream.close();
                        }
                        catch (IOException e2) {
                            ExcelExporter.this.logError(e2);
                        }
                        ExcelExporter.this.layer.setClientAreaProvider(ExcelExporter.this.originalClientAreaProvider);
                        ExcelExporter.this.layer.doCommand(new TurnViewportOnCommand());
                        progressBar.dispose();
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        ExcelExporter.this.logError(e);
                    }
                    ExcelExporter.this.layer.setClientAreaProvider(ExcelExporter.this.originalClientAreaProvider);
                    ExcelExporter.this.layer.doCommand(new TurnViewportOnCommand());
                    progressBar.dispose();
                }
            }
        };
        shell.getDisplay().asyncExec(exporter);
    }

    private void logError(Exception e) {
        System.err.println("Excel Exporter failed: " + e.getMessage());
        e.printStackTrace(System.err);
    }

    private void writeHeader(OutputStream outputStream) throws IOException {
        InputStream headerStream = null;
        try {
            try {
                int c;
                headerStream = this.getClass().getResourceAsStream(EXCEL_HEADER_FILE);
                while ((c = headerStream.read()) != -1) {
                    outputStream.write(c);
                }
            }
            catch (Exception e) {
                this.logError(e);
                if (ObjectUtils.isNotNull(headerStream)) {
                    headerStream.close();
                }
            }
        }
        finally {
            if (ObjectUtils.isNotNull(headerStream)) {
                headerStream.close();
            }
        }
    }

    private String getCellAsHTML(LayerCell cell) {
        Object dataValue = cell.getDataValue();
        return String.format("<td %s>%s</td>", this.getStyleAsHtmlAttribute(cell), dataValue != null ? dataValue : DEFAULT);
    }

    private String getStyleAsHtmlAttribute(LayerCell cell) {
        CellStyleProxy cellStyle = new CellStyleProxy(this.configRegistry, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        Color fg = cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Font font = cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        return String.format("style='color: %s; background-color: %s; %s;'", this.getColorInCSSFormat(fg), this.getColorInCSSFormat(bg), this.getFontInCSSFormat(font));
    }

    private String getFontInCSSFormat(Font font) {
        FontData fontData = font.getFontData()[0];
        String fontName = fontData.getName();
        int fontStyle = fontData.getStyle();
        String[] HTML_STYLES = new String[]{"NORMAL", "BOLD", "ITALIC"};
        return String.format("font: %s; font-family: %s", fontStyle <= 2 ? HTML_STYLES[fontStyle] : HTML_STYLES[0], fontName);
    }

    private String getColorInCSSFormat(Color color) {
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    private byte[] asBytes(String string) {
        return string.getBytes();
    }
}

