/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group.action;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupUtils;
import net.sourceforge.nattable.group.command.ReorderColumnGroupCommand;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.reorder.action.ColumnReorderDragMode;
import org.eclipse.swt.events.MouseEvent;

public class ColumnGroupHeaderReorderDragMode
extends ColumnReorderDragMode {
    private final ColumnGroupModel model;
    private MouseEvent event;

    public ColumnGroupHeaderReorderDragMode(ColumnGroupModel model) {
        this.model = model;
    }

    protected boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition, MouseEvent event) {
        this.event = event;
        toGridColumnPosition = natLayer.getColumnPositionByX(event.x);
        return this.isValidTargetColumnPosition(natLayer, fromGridColumnPosition, toGridColumnPosition);
    }

    protected boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition) {
        int toColumnIndex = natLayer.getColumnIndexByPosition(toGridColumnPosition);
        boolean betweenGroups = false;
        if (this.event != null) {
            int minX = this.event.x - 4;
            int maxX = this.event.x + 4;
            betweenGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.model);
        }
        return !this.model.isPartOfAGroup(toColumnIndex) || betweenGroups;
    }

    protected void fireMoveCommand(NatTable natTable) {
        natTable.doCommand(new ReorderColumnGroupCommand(natTable, this.dragFromGridColumnPosition, this.dragToGridColumnPosition));
    }
}

