/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.painter.cell;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.CellPainterWrapper;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class BackgroundImagePainter
extends CellPainterWrapper {
    public final Color separatorColor;
    private final Image bgImage;

    public BackgroundImagePainter(ICellPainter interiorPainter, Image bgImage, Color separatorColor) {
        super(interiorPainter);
        this.bgImage = bgImage;
        this.separatorColor = separatorColor;
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredWidth(cell, gc, configRegistry) + 4;
    }

    public int getPreferredHeight(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredHeight(cell, gc, configRegistry) + 4;
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        Color originalBackground = gc.getBackground();
        Color originalForeground = gc.getForeground();
        gc.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), this.bgImage));
        gc.fillRectangle(rectangle);
        gc.setBackgroundPattern(null);
        if (ObjectUtils.isNotNull(this.separatorColor)) {
            gc.setForeground(this.separatorColor);
            gc.drawLine(rectangle.x - 1, rectangle.y, rectangle.x - 1, rectangle.y + rectangle.height);
            gc.drawLine(rectangle.x - 1 + rectangle.width, rectangle.y, rectangle.x - 1 + rectangle.width, rectangle.y + rectangle.height);
        }
        gc.setBackground(originalBackground);
        gc.setForeground(originalForeground);
        Rectangle interiorBounds = new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
    }
}

