/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.painter.cell.decorator;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CellPainterDecorator
implements ICellPainter {
    private final ICellPainter baseCellPainter;
    private final CellEdgeEnum cellEdge;
    private final int spacing;
    private final ICellPainter decoratorCellPainter;

    public CellPainterDecorator(ICellPainter baseCellPainter, CellEdgeEnum cellEdge, ICellPainter decoratorCellPainter) {
        this(baseCellPainter, cellEdge, 2, decoratorCellPainter);
    }

    public CellPainterDecorator(ICellPainter baseCellPainter, CellEdgeEnum cellEdge, int spacing, ICellPainter decoratorCellPainter) {
        this.baseCellPainter = baseCellPainter;
        this.cellEdge = cellEdge;
        this.spacing = spacing;
        this.decoratorCellPainter = decoratorCellPainter;
    }

    public int getPreferredWidth(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.baseCellPainter.getPreferredWidth(cell, gc, configRegistry) + this.spacing + this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry);
    }

    public int getPreferredHeight(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.baseCellPainter.getPreferredHeight(cell, gc, configRegistry) + this.spacing + this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry);
    }

    public void paintCell(LayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        int x = bounds.x + (this.cellEdge == CellEdgeEnum.LEFT ? this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry) + this.spacing : 0);
        int y = bounds.y + (this.cellEdge == CellEdgeEnum.TOP ? this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry) + this.spacing : 0);
        Rectangle baseCellPainterBounds = new Rectangle(x, y, bounds.width, bounds.height).intersection(bounds);
        this.baseCellPainter.paintCell(cell, gc, baseCellPainterBounds, configRegistry);
        x = bounds.x + (this.cellEdge == CellEdgeEnum.RIGHT ? bounds.width - this.spacing - this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry) : 0);
        y = bounds.y + (this.cellEdge == CellEdgeEnum.BOTTOM ? bounds.height - this.spacing - this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry) : 0);
        Rectangle decoratorCellPainterBounds = new Rectangle(x, y, bounds.width, bounds.height).intersection(bounds);
        this.decoratorCellPainter.paintCell(cell, gc, decoratorCellPainterBounds, configRegistry);
    }
}

