/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.resize;

import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import org.eclipse.swt.graphics.GC;

public class MaxCellBoundsHelper {
    public static int[] getPreferedColumnWidths(IConfigRegistry configRegistry, GC gc, ILayer layer, int[] columnPositions) {
        int[] columnWidths = new int[columnPositions.length];
        int i = 0;
        while (i < columnPositions.length) {
            columnWidths[i] = MaxCellBoundsHelper.getPreferredColumnWidth(layer, columnPositions[i], configRegistry, gc);
            ++i;
        }
        return columnWidths;
    }

    public static int getPreferredColumnWidth(ILayer layer, int columnPosition, IConfigRegistry configRegistry, GC gc) {
        int maxWidth = 0;
        int rowPosition = 0;
        while (rowPosition < layer.getRowCount()) {
            ICellPainter painter;
            LayerCell cell = layer.getCellByPosition(columnPosition, rowPosition);
            if (cell != null && (painter = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_PAINTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels())) != null) {
                int preferedWidth = painter.getPreferredWidth(cell, gc, configRegistry);
                maxWidth = preferedWidth > maxWidth ? preferedWidth : maxWidth;
            }
            ++rowPosition;
        }
        return maxWidth;
    }

    public static int[] getPreferedRowHeights(IConfigRegistry configRegistry, GC gc, ILayer layer, int[] rows) {
        int[] rowHeights = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            rowHeights[i] = MaxCellBoundsHelper.getPreferredRowHeight(layer, rows[i], configRegistry, gc);
            ++i;
        }
        return rowHeights;
    }

    public static int getPreferredRowHeight(ILayer layer, int rowPosition, IConfigRegistry configRegistry, GC gc) {
        int maxHeight = 0;
        int columnPosition = 0;
        while (columnPosition < layer.getColumnCount()) {
            ICellPainter painter;
            LayerCell cell = layer.getCellByPosition(columnPosition, rowPosition);
            if (cell != null && (painter = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_PAINTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels())) != null) {
                int preferedHeight = painter.getPreferredHeight(cell, gc, configRegistry);
                maxHeight = preferedHeight > maxHeight ? preferedHeight : maxHeight;
            }
            ++columnPosition;
        }
        return maxHeight;
    }

    public static int[] greater(int[] array1, int[] array2) {
        int resultSize = array1.length < array2.length ? array1.length : array2.length;
        int[] result = new int[resultSize];
        int i = 0;
        while (i < resultSize) {
            result[i] = array1[i] > array2[i] ? array1[i] : array2[i];
            ++i;
        }
        return result;
    }
}

