/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;

public abstract class CodecReader
extends LeafReader
implements Accountable {
    protected CodecReader() {
    }

    public abstract StoredFieldsReader getFieldsReader();

    public abstract TermVectorsReader getTermVectorsReader();

    public abstract NormsProducer getNormsReader();

    public abstract DocValuesProducer getDocValuesReader();

    public abstract FieldsProducer getPostingsReader();

    public abstract PointsReader getPointsReader();

    @Override
    public final void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.checkBounds(docID);
        this.getFieldsReader().visitDocument(docID, visitor);
    }

    @Override
    public final Fields getTermVectors(int docID) throws IOException {
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        this.checkBounds(docID);
        return termVectorsReader.get(docID);
    }

    private void checkBounds(int docID) {
        if (docID < 0 || docID >= this.maxDoc()) {
            throw new IndexOutOfBoundsException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + docID + ")");
        }
    }

    @Override
    public final Terms terms(String field) throws IOException {
        return this.getPostingsReader().terms(field);
    }

    private FieldInfo getDVField(String field, DocValuesType type) {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public final NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getNumeric(fi);
    }

    @Override
    public final BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getBinary(fi);
    }

    @Override
    public final SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSorted(fi);
    }

    @Override
    public final SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedNumeric(fi);
    }

    @Override
    public final SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field, DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        return this.getDocValuesReader().getSortedSet(fi);
    }

    @Override
    public final NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.getNormsReader().getNorms(fi);
    }

    @Override
    public final PointValues getPointValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || fi.getPointDimensionCount() == 0) {
            return null;
        }
        return this.getPointsReader().getValues(field);
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public long ramBytesUsed() {
        this.ensureOpen();
        long ramBytesUsed = this.getPostingsReader().ramBytesUsed();
        if (this.getNormsReader() != null) {
            ramBytesUsed += this.getNormsReader().ramBytesUsed();
        }
        if (this.getDocValuesReader() != null) {
            ramBytesUsed += this.getDocValuesReader().ramBytesUsed();
        }
        if (this.getFieldsReader() != null) {
            ramBytesUsed += this.getFieldsReader().ramBytesUsed();
        }
        if (this.getTermVectorsReader() != null) {
            ramBytesUsed += this.getTermVectorsReader().ramBytesUsed();
        }
        if (this.getPointsReader() != null) {
            ramBytesUsed += this.getPointsReader().ramBytesUsed();
        }
        return ramBytesUsed;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        this.ensureOpen();
        ArrayList<Accountable> resources = new ArrayList<Accountable>(6);
        resources.add(Accountables.namedAccountable("postings", this.getPostingsReader()));
        if (this.getNormsReader() != null) {
            resources.add(Accountables.namedAccountable("norms", this.getNormsReader()));
        }
        if (this.getDocValuesReader() != null) {
            resources.add(Accountables.namedAccountable("docvalues", this.getDocValuesReader()));
        }
        if (this.getFieldsReader() != null) {
            resources.add(Accountables.namedAccountable("stored fields", this.getFieldsReader()));
        }
        if (this.getTermVectorsReader() != null) {
            resources.add(Accountables.namedAccountable("term vectors", this.getTermVectorsReader()));
        }
        if (this.getPointsReader() != null) {
            resources.add(Accountables.namedAccountable("points", this.getPointsReader()));
        }
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        this.getPostingsReader().checkIntegrity();
        if (this.getNormsReader() != null) {
            this.getNormsReader().checkIntegrity();
        }
        if (this.getDocValuesReader() != null) {
            this.getDocValuesReader().checkIntegrity();
        }
        if (this.getFieldsReader() != null) {
            this.getFieldsReader().checkIntegrity();
        }
        if (this.getTermVectorsReader() != null) {
            this.getTermVectorsReader().checkIntegrity();
        }
        if (this.getPointsReader() != null) {
            this.getPointsReader().checkIntegrity();
        }
    }
}

