/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.ui.impl;

import org.eclipse.birt.data.oda.mongodb.impl.MongoDBDriver;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.ui.i18n.Messages;
import org.eclipse.birt.data.oda.mongodb.ui.util.UIHelper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MongoDBAdvancedSettingsDialog
extends StatusDialog {
    private static String DIALOG_TITLE = Messages.getString("MongoDBAdvancedSettingsDialog.dialogTitle");
    private String batchSizeValue;
    private String docSearchLimitValue;
    private String maxSkipDocValue;
    private String indexExpr;
    private String queryPreferenceMode;
    private String tagSetValue;
    private Combo queryPreferenceModeCombo;
    private Text batchSizeText;
    private Text docSearchLimitText;
    private Text maxSkipDocText;
    private Text indexExprText;
    private Text tagSetText;
    private Button noTimeOutCheckbox;
    private Button allowPartialResultsCheckbox;
    private Button flattenNestedDocCheckbox;
    private boolean noTimeOut;
    private boolean allowsPartialResults;
    private boolean flattenNestedDocument;

    public MongoDBAdvancedSettingsDialog(Shell parent) {
        super(parent);
    }

    public void create() {
        super.create();
        Point pt = this.getShell().computeSize(-1, -1);
        pt.x = Math.max(pt.x, 250);
        pt.y = Math.max(pt.y, 300);
        this.getShell().setSize(pt);
        this.getShell().setText(DIALOG_TITLE);
        this.validatePageStatus();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createMainArea(composite);
        this.initDialogControls();
        UIHelper.setSystemHelp((Control)composite, "org.eclipse.birt.cshelp.MongoDB_DataSetAdvancedPropertyDialog_ID");
        return composite;
    }

    private void createMainArea(Composite parent) {
        Label maxResObjLabel = new Label(parent, 0);
        maxResObjLabel.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Label.MaxResultObjects"));
        maxResObjLabel.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Tooltip.MaxResultObjects"));
        this.batchSizeText = new Text(parent, 2048);
        this.batchSizeText.setLayoutData((Object)new GridData(768));
        this.batchSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBAdvancedSettingsDialog.this.batchSizeValue = MongoDBAdvancedSettingsDialog.this.batchSizeText.getText().trim();
                MongoDBAdvancedSettingsDialog.this.validatePageStatus();
            }
        });
        Label maxSearchDocLabel = new Label(parent, 0);
        maxSearchDocLabel.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Label.MaxDocumentsToSearch"));
        maxSearchDocLabel.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Tooltip.MaxDocumentsToSearch"));
        this.docSearchLimitText = new Text(parent, 2048);
        this.docSearchLimitText.setLayoutData((Object)new GridData(768));
        this.docSearchLimitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBAdvancedSettingsDialog.this.docSearchLimitValue = MongoDBAdvancedSettingsDialog.this.docSearchLimitText.getText().trim();
                MongoDBAdvancedSettingsDialog.this.validatePageStatus();
            }
        });
        Label maxSkipDocLabel = new Label(parent, 0);
        maxSkipDocLabel.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Label.MaxDocumentsToSkip"));
        maxSkipDocLabel.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Tooltip.MaxDocumentsToSkip"));
        this.maxSkipDocText = new Text(parent, 2048);
        this.maxSkipDocText.setLayoutData((Object)new GridData(768));
        this.maxSkipDocText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBAdvancedSettingsDialog.this.maxSkipDocValue = MongoDBAdvancedSettingsDialog.this.maxSkipDocText.getText().trim();
                MongoDBAdvancedSettingsDialog.this.validatePageStatus();
            }
        });
        Label indexExprLabel = new Label(parent, 0);
        indexExprLabel.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Label.IndexHintExpression"));
        indexExprLabel.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Tooltip.IndexHintExpression"));
        this.indexExprText = new Text(parent, 2048);
        this.indexExprText.setLayoutData((Object)new GridData(768));
        this.indexExprText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBAdvancedSettingsDialog.this.indexExpr = MongoDBAdvancedSettingsDialog.this.indexExprText.getText().trim();
                MongoDBAdvancedSettingsDialog.this.validatePageStatus();
            }
        });
        this.createQueryPreferenceGroup(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 8;
        this.noTimeOutCheckbox = new Button(parent, 96);
        this.noTimeOutCheckbox.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Button.text.NoCursorTimeOut"));
        this.noTimeOutCheckbox.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Button.tooltip.NoCursorTimeOut"));
        this.noTimeOutCheckbox.setLayoutData((Object)gd);
        this.noTimeOutCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBAdvancedSettingsDialog.this.noTimeOut = MongoDBAdvancedSettingsDialog.this.noTimeOutCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.allowPartialResultsCheckbox = new Button(parent, 96);
        this.allowPartialResultsCheckbox.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Button.text.AllowPartialResults"));
        this.allowPartialResultsCheckbox.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Button.tooltip.AllowPartialResults"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.allowPartialResultsCheckbox.setLayoutData((Object)gd);
        this.allowPartialResultsCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBAdvancedSettingsDialog.this.allowsPartialResults = MongoDBAdvancedSettingsDialog.this.allowPartialResultsCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.flattenNestedDocCheckbox = new Button(parent, 96);
        this.flattenNestedDocCheckbox.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Button.text.FlattenNestedDocuments"));
        this.flattenNestedDocCheckbox.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Button.tooltip.FlattenNestedDocuments"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.flattenNestedDocCheckbox.setLayoutData((Object)gd);
        this.flattenNestedDocCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBAdvancedSettingsDialog.this.flattenNestedDocument = MongoDBAdvancedSettingsDialog.this.flattenNestedDocCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createQueryPreferenceGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Group.text.QueryCursorPreference"));
        group.setLayout((Layout)new GridLayout(2, false));
        GridData groupGd = new GridData(768);
        groupGd.horizontalSpan = 2;
        group.setLayoutData((Object)groupGd);
        Label modeLabel = new Label((Composite)group, 0);
        modeLabel.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Label.QueryCursorPreference.Mode"));
        modeLabel.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Tooltip.QueryCursorPreference.Mode"));
        this.queryPreferenceModeCombo = new Combo((Composite)group, 2056);
        this.queryPreferenceModeCombo.setLayoutData((Object)new GridData(768));
        this.queryPreferenceModeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBAdvancedSettingsDialog.this.queryPreferenceMode = MongoDBAdvancedSettingsDialog.this.queryPreferenceModeCombo.getText().trim();
                MongoDBAdvancedSettingsDialog.this.updateTagSetTextStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label tagSetLabel = new Label((Composite)group, 0);
        tagSetLabel.setText(Messages.getString("MongoDBAdvancedSettingsDialog.Label.QueryCursorPreference.TagSet"));
        tagSetLabel.setToolTipText(Messages.getString("MongoDBAdvancedSettingsDialog.Tooltip.QueryCursorPreference.TagSet"));
        this.tagSetText = new Text((Composite)group, 2048);
        this.tagSetText.setLayoutData((Object)new GridData(768));
        this.tagSetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MongoDBAdvancedSettingsDialog.this.tagSetValue = MongoDBAdvancedSettingsDialog.this.tagSetText.getText().trim();
            }
        });
        this.initQueryCursorPreferenceSelection();
    }

    private void initQueryCursorPreferenceSelection() {
        this.queryPreferenceModeCombo.add(MongoDBDriver.ReadPreferenceChoice.PRIMARY.displayName());
        this.queryPreferenceModeCombo.add(MongoDBDriver.ReadPreferenceChoice.PRIMARY_PREFERRED.displayName());
        this.queryPreferenceModeCombo.add(MongoDBDriver.ReadPreferenceChoice.SECONDARY.displayName());
        this.queryPreferenceModeCombo.add(MongoDBDriver.ReadPreferenceChoice.SECONDARY_PREFERRED.displayName());
        this.queryPreferenceModeCombo.add(MongoDBDriver.ReadPreferenceChoice.NEAREST.displayName());
        this.queryPreferenceModeCombo.select(0);
    }

    private void updateTagSetTextStatus() {
        this.tagSetText.setEnabled(!MongoDBDriver.ReadPreferenceChoice.PRIMARY.displayName().equals(this.queryPreferenceModeCombo.getText().trim()));
    }

    private void validatePageStatus() {
        Status status = null;
        status = !UIHelper.isEmptyString(this.batchSizeValue) && !UIHelper.isNumber(this.batchSizeValue) ? this.getMiscStatus(4, Messages.getString("MongoDBAdvancedSettingsDialog.error.NotNumberFormat.MaxResultObjects")) : (!UIHelper.isEmptyString(this.docSearchLimitValue) && !UIHelper.isNumber(this.docSearchLimitValue) ? this.getMiscStatus(4, Messages.getString("MongoDBAdvancedSettingsDialog.error.NotNumberFormat.MaxDocumentsToSearch")) : (!UIHelper.isEmptyString(this.maxSkipDocValue) && !UIHelper.isNumberOrZero(this.maxSkipDocValue) ? this.getMiscStatus(4, Messages.getString("MongoDBAdvancedSettingsDialog.error.NotNumberFormat.MaxDocumentsToSkip")) : this.getOKStatus()));
        if (status != null) {
            this.updateStatus((IStatus)status);
        }
    }

    private Status getMiscStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.ui", severity, message, null);
    }

    private Status getOKStatus() {
        return this.getMiscStatus(0, "");
    }

    private void initDialogControls() {
        if (this.batchSizeValue != null) {
            this.batchSizeText.setText(this.batchSizeValue);
        }
        if (this.docSearchLimitValue != null) {
            this.docSearchLimitText.setText(this.docSearchLimitValue);
        }
        if (this.maxSkipDocValue != null) {
            this.maxSkipDocText.setText(this.maxSkipDocValue);
        }
        if (this.indexExpr != null) {
            this.indexExprText.setText(this.indexExpr);
        }
        if (this.queryPreferenceMode != null) {
            this.queryPreferenceModeCombo.setText(this.queryPreferenceMode);
        }
        if (this.tagSetValue != null) {
            this.tagSetText.setText(this.tagSetValue);
        }
        this.updateTagSetTextStatus();
        if (this.docSearchLimitValue != null) {
            this.docSearchLimitText.setText(this.docSearchLimitValue);
        }
        this.noTimeOutCheckbox.setSelection(this.noTimeOut);
        this.allowPartialResultsCheckbox.setSelection(this.allowsPartialResults);
        this.flattenNestedDocCheckbox.setSelection(this.flattenNestedDocument);
    }

    protected void initQueryProps(QueryProperties queryProps) {
        this.docSearchLimitValue = "";
        this.batchSizeValue = "";
        this.maxSkipDocValue = "";
        if (queryProps.hasRuntimeMetaDataSearchLimit()) {
            this.docSearchLimitValue = String.valueOf(queryProps.getRuntimeMetaDataSearchLimit());
        }
        if (queryProps.hasBatchSize()) {
            this.batchSizeValue = String.valueOf(queryProps.getBatchSize());
        }
        if (queryProps.hasNumDocsToSkip()) {
            this.maxSkipDocValue = String.valueOf(queryProps.getNumDocsToSkip());
        }
        this.queryPreferenceMode = queryProps.getQueryReadPreference() != null ? String.valueOf(queryProps.getQueryReadPreference()) : MongoDBDriver.ReadPreferenceChoice.DEFAULT.displayName();
        this.tagSetValue = queryProps.getQueryReadPreferenceTags();
        if (this.tagSetValue == null) {
            this.tagSetValue = "";
        }
        this.indexExpr = String.valueOf(queryProps.getIndexHints());
        this.noTimeOut = queryProps.hasNoTimeOut();
        this.flattenNestedDocument = queryProps.isAutoFlattening();
        this.allowsPartialResults = queryProps.isPartialResultsOk();
    }

    protected void updateQueryProperties(QueryProperties queryProps) {
        if (this.hasMaxDocumentToSkip()) {
            queryProps.setNumDocsToSkip(this.getMaxDocumentToSkip());
        } else {
            queryProps.setNumDocsToSkip(null);
        }
        if (this.hasBatchSize()) {
            queryProps.setBatchSize(this.getMaxBatchSize());
        } else {
            queryProps.setBatchSize(null);
        }
        if (this.hasDocumentSearchLimit()) {
            queryProps.setRuntimeMetaDataSearchLimit(this.getDocumentSearchLimit());
        } else {
            queryProps.setRuntimeMetaDataSearchLimit(null);
        }
        if (this.indexExpr != null) {
            queryProps.setIndexHints(this.indexExpr);
        }
        if (this.queryPreferenceMode != null) {
            queryProps.setQueryReadPreference(this.queryPreferenceMode);
        }
        if (this.tagSetValue != null) {
            queryProps.setQueryReadPreferenceTags(this.tagSetValue);
        }
        queryProps.setNoTimeOut(Boolean.valueOf(this.noTimeOut));
        queryProps.setPartialResultsOk(Boolean.valueOf(this.allowsPartialResults));
        queryProps.setAutoFlattening(Boolean.valueOf(this.flattenNestedDocument));
    }

    private boolean hasBatchSize() {
        return !UIHelper.isEmptyString(this.batchSizeValue);
    }

    protected Integer getMaxBatchSize() {
        return Integer.parseInt(this.batchSizeValue);
    }

    private boolean hasDocumentSearchLimit() {
        return !UIHelper.isEmptyString(this.docSearchLimitValue);
    }

    protected Integer getDocumentSearchLimit() {
        return Integer.parseInt(this.docSearchLimitValue);
    }

    private boolean hasMaxDocumentToSkip() {
        return !UIHelper.isEmptyString(this.maxSkipDocValue);
    }

    protected Integer getMaxDocumentToSkip() {
        return Integer.parseInt(this.maxSkipDocValue);
    }
}

