/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.excel.ui.wizards;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.birt.report.data.oda.excel.ui.i18n.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class RelativeFileSelectionDialog
extends ElementTreeSelectionDialog {
    private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private File rootFolder;
    private String[] extensions;
    private Button importButton;

    public RelativeFileSelectionDialog(Shell parent, File rootFolder, String[] extensions) {
        super(parent, (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new ContentProvider(extensions));
        this.setHelpAvailable(false);
        assert (rootFolder != null);
        this.setValidator(new SelectionValidator());
        this.setInput(rootFolder.getAbsolutePath());
        this.setTitle("SelectFile.Title");
        this.rootFolder = rootFolder;
        this.extensions = extensions;
    }

    public URI getSelectedURI() throws URISyntaxException {
        Object[] selection = this.getResult();
        if (selection != null && selection.length > 0 && selection[0] instanceof File) {
            URI baseURI = this.rootFolder.toURI();
            return baseURI.relativize(((File)selection[0]).toURI());
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        this.createImportFileArea((Composite)c);
        this.getTreeViewer().expandToLevel(2);
        return c;
    }

    private void createImportFileArea(Composite parent) {
        this.importButton = new Button(parent, 8);
        this.importButton.setText(Messages.getString("RelativeFileSelectionDialog.button.importFile"));
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(RelativeFileSelectionDialog.this.getShell());
                dialog.setFilterExtensions(RelativeFileSelectionDialog.this.extensions);
                String selectedLocation = dialog.open();
                if (selectedLocation != null) {
                    File srcFile;
                    File targetFolder = RelativeFileSelectionDialog.this.getSelectedFolder();
                    File targetFile = new File(targetFolder, (srcFile = new File(selectedLocation)).getName());
                    if (targetFile.exists() && !MessageDialog.openConfirm((Shell)RelativeFileSelectionDialog.this.getShell(), (String)Messages.getString("RelativeFileSelectionDialog.title.overwrite"), (String)Messages.getString("RelativeFileSelectionDialog.overwrite.msg"))) {
                        return;
                    }
                    RelativeFileSelectionDialog.this.importFile(targetFile, srcFile);
                    RelativeFileSelectionDialog.this.refreshResource(targetFile);
                    RelativeFileSelectionDialog.this.getTreeViewer().refresh((Object)targetFolder);
                    RelativeFileSelectionDialog.this.getTreeViewer().expandToLevel((Object)targetFolder, 1);
                }
            }
        });
    }

    private void refreshResource(File file) {
        IPath resPath = Path.fromOSString((String)file.getAbsolutePath());
        IFile[] res = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(resPath);
        if (res.length == 0 && (res = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(resPath)).length == 0) {
            return;
        }
        try {
            IFile[] targes;
            IFile[] iFileArray = targes = res;
            int n = targes.length;
            int n2 = 0;
            while (n2 < n) {
                IFile rc = iFileArray[n2];
                rc.refreshLocal(2, null);
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File getSelectedFolder() {
        Object[] selection = this.getResult();
        if (selection != null && selection.length > 0 && selection[0] instanceof File) {
            File f = (File)selection[0];
            if (f.isFile()) {
                return f.getParentFile();
            }
            return f;
        }
        return null;
    }

    private void importFile(final File target, final File src) {
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString("RelativeFileSelectionDialog.import.msg"), 1);
                    try {
                        try {
                            RelativeFileSelectionDialog.this.doImport(target, src);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("RelativeFileSelectionDialog.title.error"), (String)e.getLocalizedMessage());
        }
    }

    private void doImport(File target, File src) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(target);
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            ((FileChannel)fcin).transferTo(0L, ((FileChannel)fcin).size(), (WritableByteChannel)((Object)fcout));
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (fcin != null) {
                fcin.close();
            }
            if (fcout != null) {
                fcout.close();
            }
        }
    }

    protected void updateOKStatus() {
        super.updateOKStatus();
        this.importButton.setEnabled(this.getSelectedFolder() != null);
    }

    public String[] getSelectedItems() {
        Object[] selected;
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = selected = this.getResult() == null ? new Object[]{} : this.getResult();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            File f = (File)o;
            if (f.isFile()) {
                URI relative = this.rootFolder.toURI().relativize(f.toURI());
                result.add(relative.getPath());
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private String[] exts;
        private final String ALL_EXT = "*.*";

        public ContentProvider(String[] extensionFilter) {
            if (extensionFilter != null) {
                ArrayList<String> filters = new ArrayList<String>();
                int i = 0;
                while (i < extensionFilter.length) {
                    String[] regxs;
                    String[] stringArray = regxs = extensionFilter[i].split(";");
                    int n = regxs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String regx = stringArray[n2];
                        String ext = regx.toLowerCase(Locale.US);
                        if (!"*.*".equals(regx)) {
                            filters.add(ext.substring(1));
                        }
                        ++n2;
                    }
                    ++i;
                }
                this.exts = filters.toArray(new String[0]);
            }
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (!f.isDirectory()) {
                    return new File[0];
                }
                Object[] result = f.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File child) {
                        if (child.isDirectory()) {
                            return true;
                        }
                        return ContentProvider.this.filter(child.getAbsolutePath());
                    }
                });
                if (result != null) {
                    Arrays.sort(result, new FileComparator());
                }
                return result == null ? new File[]{} : result;
            }
            return null;
        }

        private boolean filter(String fileName) {
            int k = 0;
            while (this.exts != null && k < this.exts.length) {
                if (fileName.toLowerCase(Locale.US).endsWith(this.exts[k])) {
                    return true;
                }
                ++k;
            }
            return false;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                return this.getChildren(f).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            if (arg0 instanceof String) {
                return new Object[]{new File((String)arg0)};
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    public static class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File o1, File o2) {
            if (o1.isDirectory() && o2.isDirectory()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isFile() && o2.isFile()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1.isDirectory() && !o2.isDirectory()) {
                return -1;
            }
            return 1;
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.isFile()) {
                    return IMG_FILE;
                }
                return IMG_FOLDER;
            }
            return null;
        }

        public String getText(Object arg0) {
            if (arg0 instanceof File) {
                File f = (File)arg0;
                if (f.getName().trim().equals("")) {
                    return f.getPath();
                }
                return f.getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private static class SelectionValidator
    implements ISelectionStatusValidator {
        private SelectionValidator() {
        }

        public IStatus validate(Object[] selections) {
            if (selections != null && selections.length > 0) {
                Object[] objectArray = selections;
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof File && ((File)o).isFile()) {
                        return new Status(0, "org.eclipse.datatools.connectivity.oda.flatfile.ui", 0, "", null);
                    }
                    ++n2;
                }
            }
            return new Status(4, "org.eclipse.datatools.connectivity.oda.flatfile.ui", 4, "", null);
        }
    }
}

