/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSequenceDesign;

public class PageSetupDesign {
    protected ArrayList<MasterPageDesign> masterPages = new ArrayList();
    protected HashMap pageMaps = new HashMap();
    protected ArrayList<PageSequenceDesign> pageSequences = new ArrayList();
    protected HashMap sequenceMaps = new HashMap();

    public Collection<MasterPageDesign> getMasterPages() {
        return this.masterPages;
    }

    public int getMasterPageCount() {
        return this.masterPages.size();
    }

    public MasterPageDesign getMasterPage(int index) {
        assert (index >= 0 && index < this.masterPages.size());
        return this.masterPages.get(index);
    }

    public void addMasterPage(MasterPageDesign page) {
        assert (page != null);
        assert (page.getName() != null);
        this.pageMaps.put(page.getName(), page);
        this.masterPages.add(page);
    }

    public MasterPageDesign findMasterPage(String pageName) {
        assert (pageName != null);
        return (MasterPageDesign)this.pageMaps.get(pageName);
    }

    public Collection<PageSequenceDesign> getPageSequences() {
        return this.pageSequences;
    }

    public int getPageSequenceCount() {
        return this.pageSequences.size();
    }

    public PageSequenceDesign getPageSequence(int index) {
        assert (index >= 0 && index < this.pageSequences.size());
        return this.pageSequences.get(index);
    }

    public void addPageSequence(PageSequenceDesign sequence) {
        assert (sequence != null);
        assert (sequence.getName() != null);
        this.sequenceMaps.put(sequence.getName(), sequence);
        this.pageSequences.add(sequence);
    }

    public PageSequenceDesign findPageSequence(String name) {
        assert (name != null);
        return (PageSequenceDesign)this.sequenceMaps.get(name);
    }
}

