/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.util.WSDLUtil;
import org.eclipse.bpel.model.util.XSDImportResolver;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.xsd.XSDSchema;

public class WSDLImportResolver
extends XSDImportResolver {
    @Override
    public String getImportType() {
        return "http://schemas.xmlsoap.org/wsdl/";
    }

    @Override
    public EObject resolve(Import imp, QName qname, String name, String refType) {
        EObject result = null;
        if (!this.getImportType().equals(imp.getImportType())) {
            return result;
        }
        if (!WSDLUtil.isWSDLType(refType) && !refType.equals("top.element")) {
            return result;
        }
        if (imp.getLocation() == null) {
            return result;
        }
        Definition definition = this.findAndLoad(imp, "wsdl", Definition.class);
        if (refType.equals("top.element")) {
            return definition;
        }
        if (definition != null) {
            result = WSDLUtil.resolveWSDLReference(definition, qname, name, refType);
        }
        return result;
    }

    protected List<Object> resolveSchemas(Definition definition) {
        if (definition == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> schemas = new ArrayList<Object>();
        if (definition.getImports() != null) {
            for (List impList : definition.getImports().values()) {
                int i = 0;
                while (i < impList.size()) {
                    ImportImpl wsdlImport = (ImportImpl)impList.get(i);
                    wsdlImport.importDefinitionOrSchema();
                    XSDSchema schema = wsdlImport.getESchema();
                    Definition wsdlDefinition = wsdlImport.getEDefinition();
                    if (schema != null) {
                        schemas.add(schema);
                    }
                    if (definition != null) {
                        schemas.addAll(this.resolveSchemas(wsdlDefinition));
                    }
                    ++i;
                }
            }
        }
        if (definition.getETypes() == null) {
            return schemas;
        }
        schemas.addAll(definition.getETypes().getSchemas());
        return schemas;
    }

    @Override
    public List<Object> resolve(Import imp, int what) {
        if (!this.getImportType().equals(imp.getImportType())) {
            return Collections.emptyList();
        }
        Definition definition = this.findAndLoad(imp, "wsdl", Definition.class);
        if (what == 2) {
            ArrayList<Object> al = new ArrayList<Object>(1);
            if (definition != null) {
                al.add(definition);
            }
            return al;
        }
        return this.resolveSchemas(definition);
    }
}

