/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

public final class ProxyURIConverterImplExtension
extends ExtensibleURIConverterImpl {
    private static final String DIR_NAME = "cache/";
    private URI baseUri;

    public ProxyURIConverterImplExtension(URI baseUri) {
        this.baseUri = baseUri;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        URI resolvedUri = uri.resolve(this.baseUri);
        InputStream stream = this.getInputStreamForUri(resolvedUri);
        if (stream != null) {
            return stream;
        }
        InputStream createInputStream = super.createInputStream(resolvedUri);
        return createInputStream;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI resolvedUri = uri.resolve(this.baseUri);
        InputStream stream = this.getInputStreamForUri(resolvedUri);
        if (stream != null) {
            return stream;
        }
        InputStream createInputStream = super.createInputStream(resolvedUri, options);
        return createInputStream;
    }

    private InputStream getInputStreamForUri(URI uri) throws IOException {
        if (uri.toString().startsWith("http://")) {
            return this.checkForLocalCopy(uri);
        }
        return null;
    }

    private InputStream checkForLocalCopy(URI uri) throws IOException {
        String fileName = uri.toString().substring(7).replace("/", "_");
        URL entry = Activator.getDefault().getBundle().getEntry(DIR_NAME + fileName);
        if (entry != null) {
            return entry.openStream();
        }
        return null;
    }

    public URI normalize(URI uri) {
        URI normalizedURI = super.normalize(uri);
        if (normalizedURI.isRelative()) {
            normalizedURI = normalizedURI.resolve(this.baseUri);
        }
        return normalizedURI;
    }
}

