/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.qt.core.index.IQObject;
import org.eclipse.cdt.internal.qt.core.index.IQmlRegistration;
import org.eclipse.cdt.internal.qt.core.index.QtIndexImpl;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQmlRegistration;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQmlUncreatable;
import org.eclipse.core.runtime.CoreException;

public class QmlRegistration
implements IQmlRegistration {
    private final QtIndexImpl qtIndex;
    private final IQmlRegistration.Kind kind;
    private final String[] ownerName;
    private final Long version;
    private final String uri;
    private final Long major;
    private final Long minor;
    private final String qmlName;
    private final String reason;
    private IQObject qObject;

    public static QmlRegistration create(QtIndexImpl qtIndex, IBinding pdom) throws CoreException {
        if (pdom instanceof QtPDOMQmlUncreatable) {
            return new QmlRegistration(qtIndex, (QtPDOMQmlUncreatable)pdom);
        }
        if (pdom instanceof QtPDOMQmlRegistration) {
            return new QmlRegistration(qtIndex, (QtPDOMQmlRegistration)pdom);
        }
        return null;
    }

    private QmlRegistration(QtIndexImpl qtIndex, QtPDOMQmlRegistration pdom) throws CoreException {
        this.qtIndex = qtIndex;
        this.kind = IQmlRegistration.Kind.Type;
        String qobjName = pdom.getQObjectName();
        this.ownerName = qobjName == null ? null : qobjName.split("::");
        this.version = pdom.getVersion();
        this.uri = pdom.getUri();
        this.major = pdom.getMajor();
        this.minor = pdom.getMinor();
        this.qmlName = pdom.getQmlName();
        this.reason = null;
    }

    private QmlRegistration(QtIndexImpl qtIndex, QtPDOMQmlUncreatable pdom) throws CoreException {
        this.qtIndex = qtIndex;
        this.kind = IQmlRegistration.Kind.Uncreatable;
        String qobjName = pdom.getQObjectName();
        this.ownerName = qobjName == null ? null : qobjName.split("::");
        this.version = pdom.getVersion();
        this.uri = pdom.getUri();
        this.major = pdom.getMajor();
        this.minor = pdom.getMinor();
        this.qmlName = pdom.getQmlName();
        this.reason = pdom.getReason();
    }

    @Override
    public IQmlRegistration.Kind getKind() {
        return this.kind;
    }

    @Override
    public IQObject getQObject() {
        if (this.qObject == null && this.ownerName != null) {
            this.qObject = this.qtIndex.findQObject(this.ownerName);
        }
        return this.qObject;
    }

    @Override
    public IQObject getOwner() {
        return this.getQObject();
    }

    @Override
    public boolean isOverride(IQObject.IMember member) {
        return false;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public Long getMajor() {
        return this.major;
    }

    @Override
    public Long getMinor() {
        return this.minor;
    }

    @Override
    public String getQmlName() {
        return this.qmlName;
    }

    @Override
    public String getReason() {
        return this.reason;
    }
}

