/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public class QtPDOMNameIndex {
    private final QtPDOMLinkage qtLinkage;
    private final Database db;
    private final BTree btree;

    public QtPDOMNameIndex(QtPDOMLinkage qtLinkage, long ptr) throws CoreException {
        this.qtLinkage = qtLinkage;
        this.db = qtLinkage.getDB();
        this.btree = new BTree(this.db, ptr, (IBTreeComparator)new StringKeyComparator());
    }

    public Collection<PDOMName> get(String key) throws CoreException {
        Finder finder = new Finder(key);
        this.btree.accept((IBTreeVisitor)finder);
        if (finder.headRec == 0L) {
            return Collections.emptyList();
        }
        ArrayList<PDOMName> names = new ArrayList<PDOMName>();
        long node = this.db.getRecPtr(finder.headRec.longValue());
        while (node != 0L) {
            names.add(new PDOMName((PDOMLinkage)this.qtLinkage, this.db.getRecPtr(node)));
            node = this.db.getRecPtr(node + 4L);
        }
        return names;
    }

    public void add(String key, PDOMName name) throws CoreException {
        IString dbKey = this.db.newString(key);
        long tmpEntry = this.db.malloc(8);
        this.db.putRecPtr(tmpEntry, dbKey.getRecord());
        long entry = this.btree.insert(tmpEntry);
        long node = 0L;
        if (entry == tmpEntry) {
            node = this.db.malloc(4);
        } else {
            dbKey.delete();
            node = tmpEntry;
        }
        this.db.putRecPtr(node, name.getRecord());
        long head = this.db.getRecPtr(entry + 4L);
        this.db.putRecPtr(node + 4L, head);
        this.db.putRecPtr(entry + 4L, node);
    }

    public void remove(String key, PDOMName name) throws CoreException {
        Finder finder = new Finder(key);
        this.btree.accept((IBTreeVisitor)finder);
        if (finder.headRec == 0L) {
            return;
        }
        long qmlRec = name.getRecord();
        long prev = finder.headRec;
        long node = this.db.getRecPtr(prev);
        while (node != 0L) {
            long rec = this.db.getRecPtr(node);
            if (rec == qmlRec) {
                long next = this.db.getRecPtr(node + 4L);
                this.db.putRecPtr(prev, next);
                this.db.free(node);
                break;
            }
            prev = node + 4L;
            node = this.db.getRecPtr(prev);
        }
    }

    private class Finder
    implements IBTreeVisitor {
        private final String key;
        public Long headRec = 0L;

        public Finder(String key) {
            this.key = key;
        }

        public int compare(long rhsRecord) throws CoreException {
            long keyRec = QtPDOMNameIndex.this.db.getRecPtr(rhsRecord);
            return keyRec == 0L ? 1 : QtPDOMNameIndex.this.db.getString(keyRec).compare(this.key, true);
        }

        public boolean visit(long record) throws CoreException {
            this.headRec = record + 4L;
            return false;
        }
    }

    private class StringKeyComparator
    implements IBTreeComparator {
        private StringKeyComparator() {
        }

        public int compare(long record1, long record2) throws CoreException {
            IString rhs;
            long lhsRec = QtPDOMNameIndex.this.db.getRecPtr(record1);
            long rhsRec = QtPDOMNameIndex.this.db.getRecPtr(record2);
            IString lhs = lhsRec == 0L ? null : QtPDOMNameIndex.this.db.getString(lhsRec);
            IString iString = rhs = rhsRec == 0L ? null : QtPDOMNameIndex.this.db.getString(rhsRec);
            if (lhs == null) {
                return rhs == null ? 0 : -1;
            }
            return rhs == null ? 1 : lhs.compare(rhs, true);
        }
    }
}

