/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogObjectEvent;
import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogObjectEventListener;

public class RefreshEventManager {
    private static RefreshEventManager refreshEventManager;
    private RefreshManager delegateRefreshManager = RefreshManager.getInstance();
    private HashMap<ICatalogObject, ArrayList<ICatalogObjectEventListener>> catalogObjectEventListeners = new HashMap();
    private ArrayList<ICatalogObjectEventListener> globalCatalogObjectEventListeners = new ArrayList();

    private RefreshEventManager() {
    }

    public static RefreshEventManager getInstance() {
        if (refreshEventManager == null) {
            refreshEventManager = new RefreshEventManager();
        }
        return refreshEventManager;
    }

    public void addCatalogObjectEventListener(ICatalogObject interestedObject, ICatalogObjectEventListener listener) {
        if (interestedObject == null) {
            if (!this.globalCatalogObjectEventListeners.contains(listener)) {
                this.globalCatalogObjectEventListeners.add(listener);
            }
        } else if (this.catalogObjectEventListeners.containsKey(interestedObject)) {
            ArrayList<ICatalogObjectEventListener> listeners = this.catalogObjectEventListeners.get(interestedObject);
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        } else {
            ArrayList<ICatalogObjectEventListener> listeners = new ArrayList<ICatalogObjectEventListener>();
            listeners.add(listener);
            this.catalogObjectEventListeners.put(interestedObject, listeners);
        }
    }

    public void removeCatalogObjectEventListener(ICatalogObject interestedObject, ICatalogObjectEventListener listener) {
        ArrayList<ICatalogObjectEventListener> listeners;
        if (interestedObject == null) {
            if (this.globalCatalogObjectEventListeners.contains(listener)) {
                this.globalCatalogObjectEventListeners.remove(listener);
            }
        } else if (this.catalogObjectEventListeners.containsKey(interestedObject) && (listeners = this.catalogObjectEventListeners.get(interestedObject)).contains(listener)) {
            listeners.remove(listener);
        }
    }

    public void refresh(CatalogObjectEvent event) {
        this.delegateRefreshManager.referesh(event.element);
        for (ICatalogObjectEventListener listener : this.globalCatalogObjectEventListeners) {
            listener.notifyChanged(event);
        }
        if (this.catalogObjectEventListeners.containsKey(event.element)) {
            ArrayList<ICatalogObjectEventListener> listeners = this.catalogObjectEventListeners.get(event.element);
            for (ICatalogObjectEventListener listener : listeners) {
                listener.notifyChanged(event);
            }
        }
    }
}

