/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.jface.action.Action;

public class ConvertToFullSelectAction
extends Action {
    SQLQueryObject sourceObject;
    SQLDomainModel domainModel;

    public ConvertToFullSelectAction(SQLDomainModel domainModel) {
        super(Messages._UI_ACTION_CONVERT_TO_FULL_SELECT);
        this.domainModel = domainModel;
    }

    public void setElement(Object obj) {
        if (obj instanceof SQLQueryObject) {
            this.sourceObject = (SQLQueryObject)obj;
        }
    }

    public void run() {
        this.convertToFullSelect();
    }

    private void convertToFullSelect() {
        if (this.sourceObject instanceof QuerySelectStatement) {
            QuerySelectStatement selectStmt = (QuerySelectStatement)this.sourceObject;
            QuerySelect qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)this.sourceObject);
            if (qSelect != null) {
                QueryCombined qCombined = StatementHelper.createQueryCombined();
                QuerySelect tempQSelect = StatementHelper.createQuerySelect();
                qCombined.setLeftQuery((QueryExpressionBody)qSelect);
                qCombined.setRightQuery((QueryExpressionBody)tempQSelect);
                selectStmt.getQueryExpr().setQuery((QueryExpressionBody)qCombined);
            }
        } else if (this.sourceObject instanceof QuerySelect && this.sourceObject.eContainer() instanceof WithTableSpecification) {
            QuerySelect sourceQSelect = (QuerySelect)this.sourceObject;
            WithTableSpecification withTable = (WithTableSpecification)this.sourceObject.eContainer();
            QueryCombined qCombined = StatementHelper.createQueryCombined();
            QuerySelect tempQSelect = StatementHelper.createQuerySelect();
            qCombined.setLeftQuery((QueryExpressionBody)sourceQSelect);
            qCombined.setRightQuery((QueryExpressionBody)tempQSelect);
            withTable.setWithTableQueryExpr((QueryExpressionBody)qCombined);
        } else if (this.sourceObject instanceof QuerySelect) {
            QuerySelect sourceQSelect = (QuerySelect)this.sourceObject;
            QueryCombined parentQCombined = null;
            QueryCombined qCombined = StatementHelper.createQueryCombined();
            QuerySelect tempQSelect = StatementHelper.createQuerySelect();
            parentQCombined = sourceQSelect.getCombinedLeft();
            if (parentQCombined == null) {
                parentQCombined = sourceQSelect.getCombinedRight();
                if (parentQCombined != null) {
                    qCombined.setLeftQuery((QueryExpressionBody)sourceQSelect);
                    qCombined.setRightQuery((QueryExpressionBody)tempQSelect);
                    parentQCombined.setRightQuery((QueryExpressionBody)qCombined);
                }
            } else {
                qCombined.setLeftQuery((QueryExpressionBody)sourceQSelect);
                qCombined.setRightQuery((QueryExpressionBody)tempQSelect);
                parentQCombined.setLeftQuery((QueryExpressionBody)qCombined);
            }
        }
        SelectHelper.refresh(this.sourceObject);
    }
}

