/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.expressions;

import java.math.BigInteger;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.utils.CorePrinter;

public class BigNumericLiteral
extends Literal {
    private BigInteger bigValue;

    public BigNumericLiteral(int start, int end, BigInteger value) {
        super(start, end);
        this.bigValue = value;
    }

    public BigNumericLiteral(int start, int end, String value, int radix) {
        super(start, end);
        this.bigValue = new BigInteger(value, radix);
    }

    @Override
    public String getValue() {
        return this.bigValue.toString();
    }

    @Override
    public int getKind() {
        return 1055;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrintLn(this.getValue());
    }
}

