/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ruby.core.Messages;
import org.eclipse.dltk.ruby.core.RubyPlugin;

public class PredefinedVariables {
    private static final String MESSAGE_PROPERTIES = "variables.properties";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String DOC = "doc";
    private static Map<String, String> nameToTypeMap = new HashMap<String, String>();
    private static Map<String, String> nameToDocMap = new HashMap<String, String>();

    static {
        try {
            URL url = RubyPlugin.getDefault().getBundle().getEntry(MESSAGE_PROPERTIES);
            try (BufferedInputStream input = null;){
                input = new BufferedInputStream(url.openStream());
                Properties props = new Properties();
                props.load(input);
                Map<String, Map<String, String>> parsedProps = PredefinedVariables.parseProperties(props, new String[]{NAME, TYPE, DOC});
                for (String key : parsedProps.keySet()) {
                    Map<String, String> entry = parsedProps.get(key);
                    String name = entry.get(NAME);
                    String type = entry.get(TYPE);
                    String doc = entry.get(DOC);
                    nameToTypeMap.put(name, type);
                    nameToDocMap.put(name, doc);
                }
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.ruby.core", 0, Messages.PredefinedVariables_unableToLoadRubyPredefinedVariables, (Throwable)e);
            RubyPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    static Map<String, Map<String, String>> parseProperties(Properties props, String[] postfixes) {
        HashMap<String, Map<String, String>> entries = new HashMap<String, Map<String, String>>();
        for (String string : props.keySet()) {
            int i = 0;
            while (i < postfixes.length) {
                String postfix = postfixes[i];
                int index = string.indexOf("_" + postfix);
                if (index != -1) {
                    String name = string.substring(0, index);
                    HashMap<String, String> entry = (HashMap<String, String>)entries.get(name);
                    if (entry == null) {
                        entry = new HashMap<String, String>();
                        entries.put(name, entry);
                    }
                    entry.put(postfix, (String)props.get(string));
                }
                ++i;
            }
        }
        return entries;
    }

    public static String getTypeOf(String name) {
        return nameToDocMap.get(name);
    }

    public static String getDocOf(String name) {
        return nameToDocMap.get(name);
    }
}

