/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.internal.nodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.formatter.FormatterBlockNode;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterTextNode;
import org.eclipse.dltk.formatter.IFormatterWriter;

public abstract class FormatterBlockWithBeginNode
extends FormatterBlockNode {
    private IFormatterTextNode begin;

    public FormatterBlockWithBeginNode(IFormatterDocument document) {
        super(document);
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        boolean indenting;
        if (this.begin != null) {
            visitor.write(context, this.begin.getStartOffset(), this.begin.getEndOffset());
        }
        if (indenting = this.isIndenting()) {
            context.incIndent();
        }
        super.accept(context, visitor);
        if (indenting) {
            context.decIndent();
        }
    }

    public IFormatterTextNode getBegin() {
        return this.begin;
    }

    public void setBegin(IFormatterTextNode begin) {
        this.begin = begin;
    }

    public int getStartOffset() {
        if (this.begin != null) {
            return this.begin.getStartOffset();
        }
        return super.getStartOffset();
    }

    public int getEndOffset() {
        if (!super.isEmpty()) {
            return super.getEndOffset();
        }
        if (this.begin != null) {
            return this.begin.getEndOffset();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.begin == null && super.isEmpty();
    }

    public List<IFormatterNode> getChildren() {
        if (this.begin == null) {
            return super.getChildren();
        }
        ArrayList<IFormatterNode> result = new ArrayList<IFormatterNode>();
        if (this.begin != null) {
            result.add((IFormatterNode)this.begin);
        }
        result.addAll(super.getChildren());
        return result;
    }

    public String toString() {
        return this.begin + "\n" + super.toString();
    }

    protected boolean isIndenting() {
        return true;
    }
}

