/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.navigator;

import org.eclipse.dltk.internal.ui.navigator.CommonLayoutActionGroup;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.OpenViewActionGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class ScriptExplorerActionProvider
extends CommonActionProvider {
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    private static final String TAG_LAYOUT = "org.eclipse.dltk.internal.ui.navigator.layout";
    private CommonLayoutActionGroup fLayoutActionGroup;
    private OpenViewActionGroup fOpenViewGroup;
    private GenerateBuildPathActionGroup fBuildPathGroup;
    private IExtensionStateModel fStateModel;
    private boolean fInViewPart = false;
    private boolean fHasFilledViewMenu = false;

    public void fillActionBars(IActionBars actionBars) {
        if (!this.fHasFilledViewMenu) {
            this.fLayoutActionGroup.fillActionBars(actionBars);
            this.fHasFilledViewMenu = true;
        }
        if (this.fInViewPart) {
            this.fOpenViewGroup.fillActionBars(actionBars);
            this.fBuildPathGroup.fillActionBars(actionBars);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fInViewPart) {
            this.fOpenViewGroup.fillContextMenu(menu);
            this.fBuildPathGroup.fillContextMenu(menu);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        this.fStateModel = site.getExtensionStateModel();
        this.fLayoutActionGroup = new CommonLayoutActionGroup(site.getStructuredViewer(), this.fStateModel);
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.fOpenViewGroup = new OpenViewActionGroup(viewPart, (ISelectionProvider)site.getStructuredViewer()){

                @Override
                protected boolean getShowProperties() {
                    return false;
                }
            };
            this.fBuildPathGroup = new GenerateBuildPathActionGroup(viewPart);
            this.fInViewPart = true;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.fInViewPart) {
            this.fOpenViewGroup.setContext(context);
            this.fBuildPathGroup.setContext(context);
        }
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        this.restoreLayoutState(memento);
    }

    private void restoreLayoutState(IMemento memento) {
        boolean isCurrentLayoutFlat = true;
        Integer state = null;
        if (memento != null) {
            state = memento.getInteger(TAG_LAYOUT);
        }
        if (state == null) {
            IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
            state = store.getInt(TAG_LAYOUT);
        }
        if (state == 2) {
            isCurrentLayoutFlat = true;
        } else if (state == 1) {
            isCurrentLayoutFlat = false;
        }
        this.fStateModel.setBooleanProperty("isLayoutFlat", isCurrentLayoutFlat);
        this.fLayoutActionGroup.setFlatLayout(isCurrentLayoutFlat);
    }

    public void saveState(IMemento aMemento) {
        super.saveState(aMemento);
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        if (this.fStateModel.getBooleanProperty("isLayoutFlat")) {
            store.setValue(TAG_LAYOUT, 2);
        } else {
            store.setValue(TAG_LAYOUT, 1);
        }
    }
}

