/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import javax.inject.Inject;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.SharedElementsDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;

public class PlaceholderEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    @Inject
    @Optional
    private IProject project;
    @Inject
    private IModelResource resource;

    @Inject
    public PlaceholderEditor() {
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Placeholder");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.PlaceholderEditor_Label;
    }

    @Override
    public String getDetailLabel(Object element) {
        MPlaceholder pl = (MPlaceholder)element;
        if (pl.getRef() != null) {
            StringBuilder b = new StringBuilder();
            b.append(((EObject)pl.getRef()).eClass().getName());
            if (pl.getRef() instanceof MUILabel) {
                MUILabel label = (MUILabel)pl.getRef();
                String l = this.getLocalizedLabel(label);
                if (l != null && l.trim().length() > 0) {
                    b.append(" (" + l + ")");
                } else if (label.getTooltip() != null && label.getTooltip().trim().length() > 0) {
                    b.append(" (" + label.getTooltip() + ")");
                } else if (pl.getRef().getElementId() != null && pl.getRef().getElementId().trim().length() > 0) {
                    b.append(" (" + pl.getRef().getElementId() + ")");
                }
            } else if (pl.getRef().getElementId() != null && pl.getRef().getElementId().trim().length() > 0) {
                b.append(" (" + pl.getRef().getElementId() + ")");
            }
            return b.toString();
        }
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.PlaceholderEditor_Descriptor;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.layout(true, true);
        }
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, (IObservableValue)master, context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID));
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, (IObservableValue)this.getMaster(), context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__ACCESSIBILITY_PHRASE));
        ControlFactory.createTextField(parent, this.Messages.PlaceholderEditor_ContainerData, (IObservableValue)master, context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__CONTAINER_DATA));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.PlaceholderEditor_Reference);
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        t.setEditable(false);
        GridData gd = new GridData(768);
        t.setLayoutData((Object)gd);
        UpdateValueStrategy t2m = new UpdateValueStrategy();
        t2m.setConverter((IConverter)new Converter(String.class, MUIElement.class){

            public Object convert(Object fromObject) {
                return null;
            }
        });
        UpdateValueStrategy m2t = new UpdateValueStrategy();
        m2t.setConverter((IConverter)new Converter(MUIElement.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    MUILabel label;
                    String l;
                    EObject o = (EObject)fromObject;
                    if (o instanceof MUILabel && !Util.isNullOrEmpty(l = PlaceholderEditor.this.getLocalizedLabel(label = (MUILabel)o))) {
                        return String.valueOf(o.eClass().getName()) + " - " + l;
                    }
                    return String.valueOf(o.eClass().getName()) + " - " + ((MUIElement)fromObject).getElementId();
                }
                return null;
            }
        });
        context.bindValue((IObservableValue)textProp.observe((Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)AdvancedPackageImpl.Literals.PLACEHOLDER__REF).observeDetail((IObservableValue)this.getMaster()), t2m, m2t);
        final Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SharedElementsDialog dialog = new SharedElementsDialog(b.getShell(), PlaceholderEditor.this.getEditor(), (MPlaceholder)PlaceholderEditor.this.getMaster().getValue(), PlaceholderEditor.this.resource, PlaceholderEditor.this.Messages);
                dialog.open();
            }
        });
        ControlFactory.createCheckBox(parent, this.Messages.PlaceholderEditor_Closeable, (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)AdvancedPackageImpl.Literals.PLACEHOLDER__CLOSEABLE));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_Visible, (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        if (this.project == null) {
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MPlaceholder.class);
        folder.setSelection(0);
        return folder;
    }

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    @Override
    public IObservableList getChildList(Object element) {
        return null;
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{AdvancedPackageImpl.Literals.PLACEHOLDER__REF})};
    }

    @Inject
    @Optional
    public void refreshOnSave(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*") Event event) {
        Object type = event.getProperty("EventType");
        Object newValue = event.getProperty("NewValue");
        if ("SET".equals(type) && Boolean.FALSE.equals(newValue) && this.context != null) {
            this.context.updateTargets();
        }
    }
}

