/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.gitflow.GitFlowConfig;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class GitFlowRepository {
    private Repository repository;
    private GitFlowConfig config;

    public GitFlowRepository(@NonNull Repository repository) {
        this.repository = repository;
        this.config = new GitFlowConfig(repository);
    }

    public boolean hasBranches() {
        try {
            List branches = Git.wrap((Repository)this.repository).branchList().call();
            return !branches.isEmpty();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasBranch(String branch) throws GitAPIException {
        String fullBranchName = "refs/heads/" + branch;
        List branchList = Git.wrap((Repository)this.repository).branchList().call();
        for (Ref ref : branchList) {
            if (!fullBranchName.equals(ref.getTarget().getName())) continue;
            return true;
        }
        return false;
    }

    public Ref findBranch(String branchName) throws IOException {
        return this.repository.exactRef("refs/heads/" + branchName);
    }

    public boolean isFeature() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.startsWith(this.getConfig().getFeaturePrefix());
    }

    public boolean isDevelop() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.equals(this.getConfig().getDevelop());
    }

    public boolean isMaster() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.equals(this.getConfig().getMaster());
    }

    public boolean isRelease() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.startsWith(this.getConfig().getReleasePrefix());
    }

    public boolean isHotfix() throws IOException {
        String branch = this.repository.getBranch();
        return branch != null && branch.startsWith(this.getConfig().getHotfixPrefix());
    }

    /*
     * Exception decompiling
     */
    public RevCommit findHead() throws WrongGitFlowStateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public RevCommit findHead(String branchName) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            RevWalk walk = new RevWalk(this.repository);
            try {
                String revstr = "refs/heads/" + branchName;
                ObjectId head = this.repository.resolve(revstr);
                if (head == null) {
                    return null;
                }
                try {
                    RevCommit revCommit = walk.parseCommit((AnyObjectId)head);
                    return revCommit;
                }
                catch (IOException | RevisionSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (walk == null) return null;
                walk.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public RevCommit findCommit(String sha1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Repository getRepository() {
        return this.repository;
    }

    public List<Ref> getFeatureBranches() {
        return this.getPrefixBranches("refs/heads/" + this.getConfig().getFeaturePrefix());
    }

    public List<Ref> getReleaseBranches() {
        return this.getPrefixBranches("refs/heads/" + this.getConfig().getReleasePrefix());
    }

    public List<Ref> getHotfixBranches() {
        return this.getPrefixBranches("refs/heads/" + this.getConfig().getHotfixPrefix());
    }

    private List<Ref> getPrefixBranches(String prefix) {
        try {
            List branches = Git.wrap((Repository)this.repository).branchList().call();
            ArrayList<Ref> prefixBranches = new ArrayList<Ref>();
            for (Ref ref : branches) {
                if (!ref.getName().startsWith(prefix)) continue;
                prefixBranches.add(ref);
            }
            return prefixBranches;
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFeatureBranchName(Ref ref) {
        return ref.getName().substring(("refs/heads/" + this.getConfig().getFeaturePrefix()).length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RevCommit findCommitForTag(String tagName) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            RevWalk revWalk = new RevWalk(this.repository);
            try {
                Ref tagRef = this.repository.exactRef("refs/tags/" + tagName);
                if (tagRef == null) {
                    return null;
                }
                return revWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (revWalk == null) return null;
                revWalk.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public void setRemote(String featureName, String value) throws IOException {
        this.getConfig().setRemote(featureName, value);
    }

    public void setUpstreamBranchName(String featureName, String value) throws IOException {
        this.getConfig().setUpstreamBranchName(featureName, value);
    }

    public String getUpstreamBranchName(String featureName) {
        return this.getConfig().getUpstreamBranchName(featureName);
    }

    public GitFlowConfig getConfig() {
        return this.config;
    }

    public boolean isOnDevelop(@NonNull RevCommit selectedCommit) throws IOException {
        String develop = this.config.getDevelopFull();
        return this.isOnBranch(selectedCommit, develop);
    }

    private boolean isOnBranch(RevCommit commit, String fullBranch) throws IOException {
        Ref branchRef = this.repository.exactRef(fullBranch);
        if (branchRef == null) {
            return false;
        }
        try {
            List list = Git.wrap((Repository)this.repository).branchList().setContains(commit.name()).call();
            return list.contains(branchRef);
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }
}

