/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.merge.GitMergeEditorInput;
import org.eclipse.egit.ui.internal.merge.MergeModeDialog;
import org.eclipse.jgit.lib.Repository;

public class MergeToolActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitMergeEditorInput input;
        int mergeMode = Activator.getDefault().getPreferenceStore().getInt("merge_mode");
        IPath[] locations = this.getSelectedLocations(event);
        if (mergeMode == 0) {
            MergeModeDialog dlg = new MergeModeDialog(this.getShell(event));
            if (dlg.open() != 0) {
                return null;
            }
            input = new GitMergeEditorInput(dlg.useWorkspace(), locations);
        } else {
            boolean useWorkspace = mergeMode == 1;
            input = new GitMergeEditorInput(useWorkspace, locations);
        }
        CompareUI.openCompareEditor((CompareEditorInput)input);
        return null;
    }

    @Override
    public boolean isEnabled() {
        IPath[] paths = this.getSelectedLocations();
        Map pathsByRepository = ResourceUtil.splitPathsByRepository(Arrays.asList(paths));
        if (pathsByRepository.size() != 1) {
            return false;
        }
        Map.Entry pathsEntry = pathsByRepository.entrySet().iterator().next();
        Repository repo = (Repository)pathsEntry.getKey();
        Collection selectedRepoPaths = (Collection)pathsEntry.getValue();
        if (selectedRepoPaths.isEmpty()) {
            return false;
        }
        IndexDiffCache cache = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache();
        if (cache == null) {
            return false;
        }
        IndexDiffCacheEntry entry = cache.getIndexDiffCacheEntry(repo);
        if (entry == null || entry.getIndexDiff() == null) {
            return false;
        }
        Set conflictingFiles = entry.getIndexDiff().getConflicting();
        if (conflictingFiles.isEmpty()) {
            return false;
        }
        for (String selectedRepoPath : selectedRepoPaths) {
            Path selectedPath = new Path(selectedRepoPath);
            for (String conflictingFile : conflictingFiles) {
                if (!selectedPath.isPrefixOf((IPath)new Path(conflictingFile))) continue;
                return true;
            }
        }
        return false;
    }
}

