/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.internal.db.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.internal.db.AbstractQueryStatement;
import org.eclipse.emf.cdo.common.internal.db.AbstractUpdateStatement;
import org.eclipse.emf.cdo.common.internal.db.DBRevisionCacheUtil;
import org.eclipse.emf.cdo.common.internal.db.cache.DBRevisionCacheSchema;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataInputImpl;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBRevisionCache
extends Lifecycle
implements InternalCDORevisionCache {
    private CDOIDProvider idProvider;
    private CDOListFactory listFactory;
    private CDOPackageRegistry packageRegistry;
    private CDORevisionFactory revisionFactory;
    private IDBAdapter dbAdapter;
    private IDBConnectionProvider dbConnectionProvider;

    public InternalCDORevisionCache instantiate(CDORevision revision) {
        throw new UnsupportedOperationException();
    }

    public CDOIDProvider getIDProvider() {
        return this.idProvider;
    }

    public void setIDProvider(CDOIDProvider idProvider) {
        this.idProvider = idProvider;
    }

    public CDOListFactory getListFactory() {
        return this.listFactory;
    }

    public void setListFactory(CDOListFactory listFactory) {
        this.listFactory = listFactory;
    }

    public CDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    public void setPackageRegistry(CDOPackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    public CDORevisionFactory getRevisionFactory() {
        return this.revisionFactory;
    }

    public void setRevisionFactory(CDORevisionFactory revisionFactory) {
        this.revisionFactory = revisionFactory;
    }

    public IDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    public void setDBAdapter(IDBAdapter dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    public IDBConnectionProvider getDBConnectionProvider() {
        return this.dbConnectionProvider;
    }

    public void setDBConnectionProvider(IDBConnectionProvider dbConnectionProvider) {
        this.dbConnectionProvider = dbConnectionProvider;
    }

    public EClass getObjectType(CDOID id) {
        return null;
    }

    public InternalCDORevision getRevision(CDOID id) {
        Connection connection = null;
        String sql = null;
        try {
            connection = this.getConnection();
            AbstractQueryStatement<InternalCDORevision> query = this.createGetRevisionByIDStatement(id);
            sql = query.getSQL();
            InternalCDORevision internalCDORevision = query.query(connection);
            return internalCDORevision;
        }
        catch (Exception e) {
            throw new DBException("Error while retrieving the revision from the database", (Throwable)e, sql);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    private AbstractQueryStatement<InternalCDORevision> createGetRevisionByIDStatement(final CDOID id) {
        return new AbstractQueryStatement<InternalCDORevision>(){

            @Override
            public String getSQL() {
                StringBuilder builder = new StringBuilder();
                builder.append("SELECT ");
                builder.append(DBRevisionCacheSchema.REVISIONS_CDOREVISION);
                builder.append(", ");
                builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
                builder.append(" FROM ");
                builder.append(DBRevisionCacheSchema.REVISIONS);
                builder.append(" WHERE ");
                builder.append(DBRevisionCacheSchema.REVISIONS_ID);
                builder.append("=? AND ");
                builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
                builder.append("=");
                builder.append(0L);
                return builder.toString();
            }

            @Override
            protected void setParameters(PreparedStatement preparedStatement) throws SQLException {
                preparedStatement.setString(1, id.toURIFragment());
            }

            @Override
            protected InternalCDORevision getResult(ResultSet resultSet) throws Exception {
                long revised = resultSet.getLong(2);
                Blob blob = resultSet.getBlob(1);
                return DBRevisionCache.this.toRevision(blob, revised);
            }
        };
    }

    public InternalCDORevision getRevision(final CDOID id, final CDOBranchPoint branchPoint) {
        Connection connection = null;
        String sql = null;
        try {
            connection = this.getConnection();
            AbstractQueryStatement<InternalCDORevision> statement = new AbstractQueryStatement<InternalCDORevision>(){

                @Override
                public String getSQL() {
                    StringBuilder builder = new StringBuilder();
                    builder.append("SELECT ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_CDOREVISION);
                    builder.append(", ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
                    builder.append(" FROM ");
                    builder.append(DBRevisionCacheSchema.REVISIONS);
                    builder.append(" WHERE ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_ID);
                    builder.append("=? AND ");
                    DBRevisionCache.appendTimestampCondition(builder);
                    return builder.toString();
                }

                @Override
                protected void setParameters(PreparedStatement preparedStatement) throws SQLException {
                    long timeStamp = branchPoint.getTimeStamp();
                    preparedStatement.setString(1, id.toURIFragment());
                    preparedStatement.setLong(2, timeStamp);
                    preparedStatement.setLong(3, timeStamp);
                }

                @Override
                protected InternalCDORevision getResult(ResultSet resultSet) throws Exception {
                    long revised = resultSet.getLong(2);
                    Blob blob = resultSet.getBlob(1);
                    return DBRevisionCache.this.toRevision(blob, revised);
                }
            };
            sql = statement.getSQL();
            InternalCDORevision internalCDORevision = (InternalCDORevision)statement.query(connection);
            return internalCDORevision;
        }
        catch (Exception e) {
            throw new DBException("Error while retrieving a revision by timestamp from the database", (Throwable)e, sql);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    public InternalCDORevision getRevisionByVersion(final CDOID id, final CDOBranchVersion branchVersion) {
        Connection connection = null;
        String sql = null;
        try {
            connection = this.getConnection();
            AbstractQueryStatement<InternalCDORevision> statement = new AbstractQueryStatement<InternalCDORevision>(){

                @Override
                public String getSQL() {
                    StringBuilder builder = new StringBuilder();
                    builder.append("SELECT ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_CDOREVISION);
                    builder.append(", ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
                    builder.append(" FROM ");
                    builder.append(DBRevisionCacheSchema.REVISIONS);
                    builder.append(" WHERE ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_ID);
                    builder.append("=? AND ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_VERSION);
                    builder.append("=?");
                    return builder.toString();
                }

                @Override
                protected void setParameters(PreparedStatement preparedStatement) throws SQLException {
                    preparedStatement.setString(1, id.toURIFragment());
                    preparedStatement.setInt(2, branchVersion.getVersion());
                }

                @Override
                protected InternalCDORevision getResult(ResultSet resultSet) throws Exception {
                    long revised = resultSet.getLong(2);
                    Blob blob = resultSet.getBlob(1);
                    return DBRevisionCache.this.toRevision(blob, revised);
                }
            };
            sql = statement.getSQL();
            InternalCDORevision internalCDORevision = (InternalCDORevision)statement.query(connection);
            return internalCDORevision;
        }
        catch (Exception e) {
            throw new DBException("Error while retrieving a revision by version from the database", (Throwable)e, sql);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    public List<CDORevision> getCurrentRevisions() {
        Connection connection = null;
        String sql = null;
        try {
            connection = this.getConnection();
            AbstractQueryStatement<List<CDORevision>> query = new AbstractQueryStatement<List<CDORevision>>(){

                @Override
                public String getSQL() {
                    StringBuilder builder = new StringBuilder();
                    builder.append("SELECT ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_CDOREVISION);
                    builder.append(", ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
                    builder.append(" FROM ");
                    builder.append(DBRevisionCacheSchema.REVISIONS);
                    builder.append(" WHERE ");
                    builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
                    builder.append("=");
                    builder.append(0L);
                    return builder.toString();
                }

                @Override
                protected void setParameters(PreparedStatement preparedStatement) throws SQLException {
                }

                @Override
                protected List<CDORevision> getResult(ResultSet resultSet) throws Exception {
                    ArrayList<CDORevision> revisionList = new ArrayList<CDORevision>();
                    do {
                        long revised = resultSet.getLong(2);
                        Blob blob = resultSet.getBlob(1);
                        revisionList.add((CDORevision)DBRevisionCache.this.toRevision(blob, revised));
                    } while (resultSet.next());
                    return revisionList;
                }
            };
            sql = query.getSQL();
            List list = (List)query.query(connection);
            return list;
        }
        catch (Exception e) {
            throw new DBException("Error while retrieving a revision by version from the database", (Throwable)e, sql);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    public void getAllRevisions(List<InternalCDORevision> result) {
        throw new UnsupportedOperationException();
    }

    public void addRevision(CDORevision revision) {
        CheckUtil.checkArg((Object)revision, (String)"revision");
        Connection connection = null;
        String sql = null;
        try {
            try {
                connection = this.getConnection();
                AbstractUpdateStatement update = this.createAddRevisionStatement((InternalCDORevision)revision);
                sql = update.getSQL();
                update.update(connection);
                if (revision.getVersion() > 1) {
                    update = this.createUpdateRevisedStatement((InternalCDORevision)revision);
                    update.update(connection);
                }
            }
            catch (DBException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DBException("Error while retrieving the revision from the database", (Throwable)e, sql);
            }
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    private AbstractUpdateStatement createUpdateRevisedStatement(final InternalCDORevision revision) {
        return new AbstractUpdateStatement(){

            public String getSQL() {
                StringBuilder builder = new StringBuilder();
                builder.append("UPDATE ");
                builder.append(DBRevisionCacheSchema.REVISIONS);
                builder.append(" SET ");
                builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
                builder.append(" =? WHERE ");
                builder.append(DBRevisionCacheSchema.REVISIONS_ID);
                builder.append(" =? AND ");
                builder.append(DBRevisionCacheSchema.REVISIONS_VERSION);
                builder.append(" =?");
                return builder.toString();
            }

            protected void setParameters(PreparedStatement preparedStatement) throws SQLException {
                preparedStatement.setLong(1, revision.getTimeStamp() - 1L);
                preparedStatement.setString(2, revision.getID().toURIFragment());
                preparedStatement.setInt(3, revision.getVersion() - 1);
            }
        };
    }

    private AbstractUpdateStatement createAddRevisionStatement(final InternalCDORevision revision) {
        return new AbstractUpdateStatement(){

            public String getSQL() {
                StringBuilder builder = new StringBuilder();
                builder.append("INSERT INTO ");
                builder.append(DBRevisionCacheSchema.REVISIONS);
                builder.append(" (");
                builder.append(DBRevisionCacheSchema.REVISIONS_ID);
                builder.append(", ");
                builder.append(DBRevisionCacheSchema.REVISIONS_VERSION);
                builder.append(", ");
                builder.append(DBRevisionCacheSchema.REVISIONS_CREATED);
                builder.append(", ");
                builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
                builder.append(", ");
                builder.append(DBRevisionCacheSchema.REVISIONS_CDOREVISION);
                builder.append(", ");
                builder.append(DBRevisionCacheSchema.REVISIONS_RESOURCENODE_NAME);
                builder.append(", ");
                builder.append(DBRevisionCacheSchema.REVISIONS_CONTAINERID);
                builder.append(") ");
                builder.append(" VALUES (?, ?, ?, ?, ?, ? ,?)");
                return builder.toString();
            }

            protected void setParameters(PreparedStatement preparedStatement) throws Exception {
                preparedStatement.setString(1, revision.getID().toURIFragment());
                preparedStatement.setInt(2, revision.getVersion());
                preparedStatement.setLong(3, revision.getTimeStamp());
                preparedStatement.setLong(4, revision.getRevised());
                preparedStatement.setBytes(5, DBRevisionCache.this.toBytes(revision));
                this.setResourceNodeValues(revision, preparedStatement);
            }

            private void setResourceNodeValues(InternalCDORevision revision2, PreparedStatement preparedStatement) throws SQLException {
                if (revision2.isResourceNode()) {
                    preparedStatement.setString(6, DBRevisionCacheUtil.getResourceNodeName((CDORevision)revision2));
                    CDOID containerID = (CDOID)revision2.getContainerID();
                    preparedStatement.setString(7, containerID.toURIFragment());
                } else {
                    preparedStatement.setNull(6, 12);
                    preparedStatement.setNull(7, 4);
                }
            }
        };
    }

    public InternalCDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        InternalCDORevision internalCDORevision;
        Connection connection = null;
        String sql = null;
        try {
            final InternalCDORevision revision = this.getRevisionByVersion(id, branchVersion);
            if (revision != null) {
                connection = this.getConnection();
                AbstractUpdateStatement statement = new AbstractUpdateStatement(){

                    public String getSQL() {
                        StringBuilder builder = new StringBuilder();
                        builder.append("DELETE FROM ");
                        builder.append(DBRevisionCacheSchema.REVISIONS);
                        builder.append(" WHERE ID =? AND VERSION =?");
                        return builder.toString();
                    }

                    protected void setParameters(PreparedStatement preparedStatement) throws Exception {
                        preparedStatement.setString(1, revision.getID().toURIFragment());
                        preparedStatement.setInt(2, revision.getVersion());
                    }
                };
                sql = statement.getSQL();
                statement.update(connection);
            }
            internalCDORevision = revision;
        }
        catch (Exception e) {
            try {
                throw new DBException("Error while removing a revision from the database", (Throwable)e, sql);
            }
            catch (Throwable throwable) {
                DBUtil.close(connection);
                throw throwable;
            }
        }
        DBUtil.close((Connection)connection);
        return internalCDORevision;
    }

    public void clear() {
        Connection connection = null;
        String sql = null;
        try {
            try {
                connection = this.getConnection();
                AbstractUpdateStatement update = new AbstractUpdateStatement(){

                    public String getSQL() {
                        StringBuilder builder = new StringBuilder();
                        builder.append("DELETE FROM  ");
                        builder.append(DBRevisionCacheSchema.REVISIONS);
                        return builder.toString();
                    }
                };
                sql = update.getSQL();
                update.update(connection);
            }
            catch (Exception e) {
                throw new DBException("Error while clearing the database", (Throwable)e, sql);
            }
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        throw new UnsupportedOperationException();
    }

    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        throw new UnsupportedOperationException();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.idProvider, "idProvider");
        this.checkState(this.listFactory, "listFactory");
        this.checkState(this.packageRegistry, "packageRegistry");
        this.checkState(this.revisionFactory, "revisionFactory");
        this.checkState(this.dbAdapter, "dbAdapter");
        this.checkState(this.dbConnectionProvider, "dbConnectionProvider");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.createTable();
    }

    private void createTable() throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            DBRevisionCacheSchema.INSTANCE.create(this.dbAdapter, connection);
            connection.commit();
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    private static StringBuilder appendTimestampCondition(StringBuilder builder) {
        builder.append(DBRevisionCacheSchema.REVISIONS_CREATED);
        builder.append("<=? AND (");
        builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
        builder.append(">=? OR ");
        builder.append(DBRevisionCacheSchema.REVISIONS_REVISED);
        builder.append("=");
        builder.append(0L);
        builder.append(")");
        return builder;
    }

    private InternalCDORevision toRevision(Blob blob, long revisedTimestamp) throws IOException, SQLException {
        CDODataInput dataInput = this.getCDODataInput(ExtendedDataInputStream.wrap((InputStream)blob.getBinaryStream()));
        InternalCDORevision revision = (InternalCDORevision)dataInput.readCDORevision();
        revision.setRevised(revisedTimestamp);
        return revision;
    }

    private CDODataInput getCDODataInput(ExtendedDataInputStream inputStream) throws IOException {
        return new CDODataInputImpl((ExtendedDataInput)inputStream){

            public CDOPackageRegistry getPackageRegistry() {
                return DBRevisionCache.this.packageRegistry;
            }

            protected CDOBranchManager getBranchManager() {
                return null;
            }

            protected CDOCommitInfoManager getCommitInfoManager() {
                return null;
            }

            protected CDORevisionFactory getRevisionFactory() {
                return DBRevisionCache.this.revisionFactory;
            }

            protected CDOListFactory getListFactory() {
                return DBRevisionCache.this.listFactory;
            }

            protected CDOLobStore getLobStore() {
                return null;
            }
        };
    }

    private byte[] toBytes(InternalCDORevision revision) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CDODataOutput dataOutput = this.getCDODataOutput((ExtendedDataOutput)ExtendedDataOutputStream.wrap((OutputStream)byteArrayOutputStream));
        dataOutput.writeCDORevision((CDORevision)revision, -1);
        return byteArrayOutputStream.toByteArray();
    }

    private CDODataOutput getCDODataOutput(ExtendedDataOutput extendedDataOutputStream) {
        return new CDODataOutputImpl(extendedDataOutputStream){

            public CDOPackageRegistry getPackageRegistry() {
                return DBRevisionCache.this.packageRegistry;
            }

            public CDOIDProvider getIDProvider() {
                return DBRevisionCache.this.idProvider;
            }
        };
    }

    private Connection getConnection() throws SQLException {
        Connection connection = this.dbConnectionProvider.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }
}

