/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.internal.migrator.CDOMigratorUtil;
import org.eclipse.emf.cdo.internal.migrator.tasks.CDOTask;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;

public class GenerateModelTask
extends CDOTask {
    private String modelPath;

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    protected void checkAttributes() throws BuildException {
        GenerateModelTask.assertTrue("'modelPath' must be specified.", this.modelPath != null && this.modelPath.length() != 0);
    }

    protected void doExecute() throws Exception {
        GenModel genModel = CDOMigratorUtil.getGenModel(this.modelPath);
        genModel.setCanGenerate(true);
        genModel.setValidateModel(true);
        Diagnostic diagnostic = genModel.diagnose();
        if (diagnostic.getSeverity() != 0) {
            System.err.println(diagnostic);
            throw new BuildException(diagnostic.getException());
        }
        BasicMonitor.Printing monitor = this.verbose ? new BasicMonitor.Printing(System.out) : BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor());
        Generator generator = GenModelUtil.createGenerator((GenModel)genModel);
        generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_ModelProject_name"), (Monitor)monitor);
    }
}

