/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.common.ui.internal.exported.views.IColumnDescription;
import org.eclipse.emf.facet.common.ui.internal.exported.views.IElementsViewFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.internal.exported.CustomizationUtils;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.internal.ImageProvider;
import org.eclipse.emf.facet.custom.ui.internal.Messages;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DocumentedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class CustomizationsCatalogView
implements IExecutableExtensionFactory,
IOpenListener {
    private static final String NAME_COLUMN = "CustomizationsView_NameColumn";
    private static final String EXTENDS_COLUMN = "CustomizationsView_ExtendsColumn";
    private static final String DOCUMENTATION_COLUMN = "CustomizationsView_DocumentationColumn";
    private static final int NAME_COLUMN_WIDTH = 300;
    private static final int EXTENDS_COLUMN_WIDTH = 300;
    private static final int DOCUMENTATION_COLUMN_WIDTH = 400;
    private ICustomizationCatalogManager customizationCatalogManager;

    public Object create() throws CoreException {
        this.customizationCatalogManager = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager((ResourceSet)new ResourceSetImpl());
        ArrayList<IColumnDescription> columnDescriptions = new ArrayList<IColumnDescription>();
        columnDescriptions.add(CustomizationsCatalogView.createNameColumnDescription());
        columnDescriptions.add(CustomizationsCatalogView.createExtendsColumnDescription());
        columnDescriptions.add(CustomizationsCatalogView.createDocumentationColumnDescription());
        return IElementsViewFactory.DEFAULT.createElementsView(columnDescriptions, CustomizationsCatalogView.getContentProvider(), this.getInput(), Messages.CustomizationsCatalogView_title, ImageProvider.getInstance().getUiCustomIcon(), (IOpenListener)this);
    }

    private static IColumnDescription createNameColumnDescription() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                String result;
                if (element instanceof ENamedElement) {
                    ENamedElement namedElement = (ENamedElement)element;
                    result = namedElement.getName();
                } else {
                    result = "<" + element.getClass().getName() + ">";
                }
                return result;
            }

            public Image getImage(Object element) {
                return ImageProvider.getInstance().getUiCustomIcon();
            }
        };
        return IElementsViewFactory.DEFAULT.createColumnDescription(Messages.CustomizationsView_nameColumn, NAME_COLUMN, 300, columnLabelProvider);
    }

    private static IColumnDescription createExtendsColumnDescription() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                Facet facet;
                EClass extendedMetaclass;
                String result = null;
                if (element instanceof Customization) {
                    Customization customization = (Customization)element;
                    EPackage customizedEPackage = CustomizationUtils.getCustomizedEPackage((Customization)customization);
                    if (customizedEPackage != null) {
                        result = customizedEPackage.getNsURI();
                    }
                } else if (element instanceof Facet && (extendedMetaclass = (facet = (Facet)element).getExtendedMetaclass()) != null) {
                    result = extendedMetaclass.getName();
                }
                return result;
            }
        };
        return IElementsViewFactory.DEFAULT.createColumnDescription(Messages.CustomizationsView_extendsColumn, EXTENDS_COLUMN, 300, columnLabelProvider);
    }

    private static IColumnDescription createDocumentationColumnDescription() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = null;
                if (element instanceof DocumentedElement) {
                    DocumentedElement documentedElement = (DocumentedElement)element;
                    result = documentedElement.getDocumentation();
                }
                return result;
            }
        };
        return IElementsViewFactory.DEFAULT.createColumnDescription(Messages.CustomizationsView_documentationColumn, DOCUMENTATION_COLUMN, 400, columnLabelProvider);
    }

    protected static ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                Collection customizations = (Collection)inputElement;
                return customizations.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                Object[] children = this.getChildren(element);
                return children != null && children.length > 0;
            }

            public Object getParent(Object element) {
                EObject result;
                if (element instanceof EObject) {
                    EObject eObject = (EObject)element;
                    result = eObject.eContainer();
                } else {
                    result = null;
                }
                return result;
            }

            public Object[] getChildren(Object parentElement) {
                Object[] result;
                if (parentElement instanceof Customization) {
                    Customization customization = (Customization)parentElement;
                    ArrayList<Customization> contents = new ArrayList<Customization>();
                    for (FacetSet facetSet : customization.getFacetSets()) {
                        if (!(facetSet instanceof Customization)) continue;
                        Customization childCustom = (Customization)facetSet;
                        contents.add(childCustom);
                    }
                    contents.addAll((Collection<Customization>)customization.getEClassifiers());
                    result = contents.toArray();
                } else {
                    result = new Object[]{};
                }
                return result;
            }
        };
    }

    protected Object getInput() {
        return this.customizationCatalogManager.getRegisteredCustomizations();
    }

    public void open(OpenEvent event) {
    }
}

