/*******************************************************************************
 * Copyright (c) 2017 Soft-Maint.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Jonathan Pepin (Soft-Maint) - Bug 517305 - Table widget refactoring #2
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.facet.widgets.table.ui.internal.exported.selection.IStructuredTableSelection;
import org.eclipse.jface.viewers.ISelection;

public class StructuredTableSelection
		implements IStructuredTableSelection {

	private final ISelection tableSelection;
	private final List<?> elements;

	public StructuredTableSelection(final ISelection tableSelection,
			final List<?> elements) {
		this.elements = elements;
		this.tableSelection = tableSelection;
	}

	public ISelection getTableSelection() {
		return this.tableSelection;
	}

	public Object getFirstElement() {
		return this.elements.get(0);
	}

	public Iterator<?> iterator() {
		return this.elements.iterator();
	}

	public int size() {
		return this.elements.size();
	}

	public Object[] toArray() {
		return this.elements.toArray();
	}

	public List<?> toList() {
		return this.elements;
	}

	public boolean isEmpty() {
		return this.elements.isEmpty();
	}
}
