/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.highlighting;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class DotHighlightingConfiguration
extends DefaultHighlightingConfiguration {
    public static final String GRAPH_NAME_ID = "graph_name";
    public static final String NODE_NAME_ID = "node_name";
    public static final String PORT_NAME_ID = "port_name";
    public static final String ATTRIBUTE_NAME_ID = "attribute_name";
    public static final String EDGE_OP_ID = "edge_op";
    public static final String QUOTED_STRING_ID = "quoted_string";
    public static final String NUMERAL_ID = "numeral";
    public static final String HTML_TAG = "html_tag";
    public static final String HTML_ATTRIBUTE_NAME = "html_attribute_name";
    public static final String HTML_ATTRIBUTE_EQUAL_SIGN = "html_attribute_equal_sign";
    public static final String HTML_ATTRIBUTE_VALUE = "html_attribute_value";
    public static final String HTML_CONTENT = "html_content";
    public static final String HTML_COMMENT = "html_comment";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        acceptor.acceptDefaultHighlighting(GRAPH_NAME_ID, "Graph Id", this.graphIdTextStyle());
        acceptor.acceptDefaultHighlighting(NODE_NAME_ID, "Node Id", this.nodeIdTextStyle());
        acceptor.acceptDefaultHighlighting(PORT_NAME_ID, "Port Id", this.portIdTextStyle());
        acceptor.acceptDefaultHighlighting(ATTRIBUTE_NAME_ID, "Attribute Id", this.attributeIdTextStyle());
        acceptor.acceptDefaultHighlighting(EDGE_OP_ID, "Edge Op", this.edgeOpTextStyle());
        acceptor.acceptDefaultHighlighting("default", "Default", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting("keyword", "Keyword", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting(NUMERAL_ID, "Numeral", this.numberTextStyle());
        acceptor.acceptDefaultHighlighting(QUOTED_STRING_ID, "Quoted String", this.quotedStringTextStyle());
        acceptor.acceptDefaultHighlighting("string", "(Unquoted) String", this.stringTextStyle());
        acceptor.acceptDefaultHighlighting("comment", "Comment", this.commentTextStyle());
        acceptor.acceptDefaultHighlighting("punctuation", "Punctuation Character", this.punctuationTextStyle());
        acceptor.acceptDefaultHighlighting("error", "Invalid Symbol", this.errorTextStyle());
        acceptor.acceptDefaultHighlighting(HTML_TAG, "Html Tag", this.htmlTagStyle());
        acceptor.acceptDefaultHighlighting(HTML_ATTRIBUTE_NAME, "Html Attribute Name", this.htmlAttributeNameStyle());
        acceptor.acceptDefaultHighlighting(HTML_ATTRIBUTE_EQUAL_SIGN, "Html Attribute Equal Sign", this.htmlAttributeEqualSignStyle());
        acceptor.acceptDefaultHighlighting(HTML_ATTRIBUTE_VALUE, "Html Attribute Value", this.htmlAttributeValueStyle());
        acceptor.acceptDefaultHighlighting(HTML_CONTENT, "Html Content", this.htmlContentStyle());
        acceptor.acceptDefaultHighlighting(HTML_COMMENT, "Html Comment", this.htmlCommentStyle());
    }

    public TextStyle graphIdTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        return textStyle;
    }

    public TextStyle nodeIdTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        return textStyle;
    }

    public TextStyle attributeIdTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 76, 153));
        return textStyle;
    }

    public TextStyle portIdTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 153, 76));
        return textStyle;
    }

    public TextStyle edgeOpTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 153, 0));
        return textStyle;
    }

    public TextStyle stringTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(153, 76, 0));
        return textStyle;
    }

    public TextStyle quotedStringTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(255, 0, 0));
        return textStyle;
    }

    public TextStyle keywordTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setStyle(1);
        return textStyle;
    }

    private TextStyle htmlTagStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(63, 127, 127));
        return textStyle;
    }

    private TextStyle htmlAttributeNameStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(127, 0, 127));
        return textStyle;
    }

    private TextStyle htmlAttributeEqualSignStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 0, 0));
        return textStyle;
    }

    private TextStyle htmlAttributeValueStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(42, 0, 255));
        textStyle.setStyle(2);
        return textStyle;
    }

    private TextStyle htmlContentStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 0, 0));
        return textStyle;
    }

    private TextStyle htmlCommentStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(63, 95, 191));
        return textStyle;
    }
}

