/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsf.common.internal.policy.CanonicallyOrderedIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.policy.IIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.policy.IdentifierOrderedIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.strategy.AbstractIdentifiableStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.IIdentifiableStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.IteratorPolicyBasedStrategyComposite;
import org.eclipse.jst.jsf.core.internal.AbstractTagRegistryFactoryProvider;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryInfo;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryProvider;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.TagLibraryRegistryLoader;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeTagRegistryFactory {
    private static CompositeTagRegistryFactory INSTANCE;
    private static ITagRegistryFactoryProvider TEST_PROVIDER;

    public synchronized void setTestInjectedProvider(ITagRegistryFactoryProvider factoryProvider) {
        TEST_PROVIDER = factoryProvider;
    }

    public static synchronized CompositeTagRegistryFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompositeTagRegistryFactory();
        }
        return INSTANCE;
    }

    private CompositeTagRegistryFactory() {
    }

    public final ITagRegistry getRegistry(TagRegistryIdentifier id) {
        Set<ITagRegistryFactoryInfo> handlers = this.getAllTagRegistryFactories();
        Set<ITagRegistryFactoryInfo> matchingHandlers = this.findMatchingExtensions(id, handlers);
        if (matchingHandlers.size() > 0) {
            if (matchingHandlers.size() == 1) {
                try {
                    return matchingHandlers.iterator().next().getTagRegistryFactory().createTagRegistry(id.getProject());
                }
                catch (TagRegistryFactory.TagRegistryFactoryException e) {
                    JSFCorePlugin.log(e, "While trying to acquire a registry");
                }
            } else {
                TagRegistrySelectionStrategy selectionStrategy = new TagRegistrySelectionStrategy((IIteratorPolicy<String>)new CanonicallyOrderedIteratorPolicy());
                Iterator<ITagRegistryFactoryInfo> it = matchingHandlers.iterator();
                while (it.hasNext()) {
                    selectionStrategy.addStrategy(it.next().getTagRegistryFactory());
                }
                return (ITagRegistry)selectionStrategy.perform(id.getProject());
            }
        }
        return null;
    }

    public Set<ITagRegistryFactoryInfo> getAllTagRegistryFactories() {
        ArrayList<String> selectionOrder = new ArrayList<String>();
        selectionOrder.add("testInjection");
        selectionOrder.add("extensionPointInjection");
        selectionOrder.add("platformDefault");
        IdentifierOrderedIteratorPolicy policy = new IdentifierOrderedIteratorPolicy(selectionOrder);
        policy.setExcludeNonExplicitValues(true);
        TagRegistryFactoryProviderSelectionStrategy providerSelector = new TagRegistryFactoryProviderSelectionStrategy((IIteratorPolicy<String>)policy);
        providerSelector.addStrategy((IIdentifiableStrategy)new AbstractIdentifiableStrategy<IProject, ITagRegistryFactoryProvider, String>("testInjection", "FIXME: not for display", null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ITagRegistryFactoryProvider perform(IProject input) throws Exception {
                ITagRegistryFactoryProvider injectedProvider = null;
                Class<CompositeTagRegistryFactory> clazz = CompositeTagRegistryFactory.class;
                synchronized (CompositeTagRegistryFactory.class) {
                    injectedProvider = TEST_PROVIDER;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    if (injectedProvider != null) {
                        final ITagRegistryFactoryProvider useMe = injectedProvider;
                        return new AbstractTagRegistryFactoryProvider(){

                            @Override
                            public Set<ITagRegistryFactoryInfo> getTagRegistryFactories() {
                                return useMe.getTagRegistryFactories();
                            }
                        };
                    }
                    return null;
                }
            }
        });
        providerSelector.addStrategy((IIdentifiableStrategy)new AbstractIdentifiableStrategy<IProject, ITagRegistryFactoryProvider, String>("platformDefault", "FIXME: not for display", null){

            public ITagRegistryFactoryProvider perform(IProject input) throws Exception {
                return new AbstractTagRegistryFactoryProvider(){

                    @Override
                    public Set<ITagRegistryFactoryInfo> getTagRegistryFactories() {
                        return TagLibraryRegistryLoader.getAllHandlers();
                    }
                };
            }
        });
        ITagRegistryFactoryProvider provider = (ITagRegistryFactoryProvider)providerSelector.perform(null);
        if (provider != null) {
            return provider.getTagRegistryFactories();
        }
        return Collections.emptySet();
    }

    private Set<ITagRegistryFactoryInfo> findMatchingExtensions(TagRegistryIdentifier id, Set<ITagRegistryFactoryInfo> handlers) {
        HashSet<ITagRegistryFactoryInfo> matching = new HashSet<ITagRegistryFactoryInfo>(4);
        for (ITagRegistryFactoryInfo handler : handlers) {
            if (!handler.getContentTypes().contains(id.getContentType()) || !handler.getTagRegistryFactory().projectIsValid(id.getProject())) continue;
            matching.add(handler);
        }
        return matching;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagRegistryFactoryProviderSelectionStrategy
    extends IteratorPolicyBasedStrategyComposite<IProject, ITagRegistryFactoryProvider, ITagRegistryFactoryProvider, String, IIdentifiableStrategy<IProject, ITagRegistryFactoryProvider, String>> {
        private static final ITagRegistryFactoryProvider NO_RESULT = null;

        protected TagRegistryFactoryProviderSelectionStrategy(IIteratorPolicy<String> policy) {
            super(policy);
        }

        public ITagRegistryFactoryProvider getNoResult() {
            return NO_RESULT;
        }
    }

    public static final class TagRegistryIdentifier {
        private final IProject _project;
        private final IContentType _contentType;

        public TagRegistryIdentifier(IProject project, IContentType contentType) {
            this._project = project;
            this._contentType = contentType;
        }

        public IProject getProject() {
            return this._project;
        }

        public IContentType getContentType() {
            return this._contentType;
        }

        public boolean equals(Object o) {
            if (o instanceof TagRegistryIdentifier) {
                int thisProjectHash;
                TagRegistryIdentifier other = (TagRegistryIdentifier)o;
                int otherProjectHash = other.getProject() != null ? other.getProject().hashCode() : 0;
                int n = thisProjectHash = this.getProject() != null ? this.getProject().hashCode() : 0;
                if (otherProjectHash == thisProjectHash && other.getContentType().equals(this.getContentType())) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return (this.getProject() != null ? this.getProject().hashCode() : 0) + 7 * this._contentType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagRegistrySelectionStrategy
    extends IteratorPolicyBasedStrategyComposite<IProject, ITagRegistry, ITagRegistry, String, IIdentifiableStrategy<IProject, ITagRegistry, String>> {
        private static final ITagRegistry NO_RESULT = null;

        protected TagRegistrySelectionStrategy(IIteratorPolicy<String> policy) {
            super(policy);
        }

        public ITagRegistry getNoResult() {
            return NO_RESULT;
        }
    }
}

