/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal.publishers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class ModulePackager {
    private static final int BUFFER_SIZE = 65536;
    private byte[] readBuffers;
    private static final String JAR_FILE_SEPERATOR = "/";
    private JarOutputStream outputStream;
    private boolean useCompression = true;

    public ModulePackager(String filename, boolean compress) throws IOException {
        Path directoryPath = new Path(filename);
        directoryPath = (Path)directoryPath.removeLastSegments(1);
        File newZipFile = new File(directoryPath.toString());
        newZipFile.mkdirs();
        this.outputStream = new JarOutputStream(new FileOutputStream(filename));
        this.useCompression = compress;
    }

    public void finished() throws IOException {
        this.outputStream.close();
    }

    protected void write(String pathname, byte[] contents) throws IOException {
        ZipEntry newEntry = new ZipEntry(pathname);
        if (!this.useCompression) {
            newEntry.setMethod(0);
            newEntry.setSize(contents.length);
            CRC32 checksumCalculator = new CRC32();
            checksumCalculator.update(contents);
            newEntry.setCrc(checksumCalculator.getValue());
        }
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.write(contents);
        this.outputStream.closeEntry();
    }

    public void writeFolder(String destinationPath) throws IOException {
        if (!destinationPath.endsWith(JAR_FILE_SEPERATOR)) {
            destinationPath = String.valueOf(destinationPath) + JAR_FILE_SEPERATOR;
        }
        ZipEntry newEntry = new ZipEntry(destinationPath);
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.closeEntry();
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        InputStream contentStream = null;
        try {
            contentStream = resource.getContents(false);
            this.write(contentStream, destinationPath);
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
    }

    public void write(File resource, String destinationPath) throws IOException, CoreException {
        FileInputStream contentStream = null;
        try {
            contentStream = new FileInputStream(resource);
            this.write(contentStream, destinationPath);
        }
        finally {
            if (contentStream != null) {
                ((InputStream)contentStream).close();
            }
        }
    }

    public void write(InputStream contentStream, String destinationPath) throws IOException, CoreException {
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream();
            if (this.readBuffers == null) {
                this.readBuffers = new byte[65536];
            }
            int n = 0;
            while (n > -1) {
                n = contentStream.read(this.readBuffers);
                if (n <= 0) continue;
                output.write(this.readBuffers, 0, n);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        this.write(destinationPath, output.toByteArray());
    }

    public void pack(File directory, String root) throws CoreException, IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String relativeFolder = this.makeRelative(files[i].getAbsolutePath(), root);
            if (files[i].isDirectory()) {
                if (relativeFolder != null) {
                    this.writeFolder(relativeFolder);
                }
                this.pack(files[i], root);
            } else if (relativeFolder != null) {
                this.write(files[i], relativeFolder);
            }
            ++i;
        }
    }

    private String makeRelative(String fileName, String root) {
        String folder = null;
        if (fileName.startsWith(root)) {
            folder = fileName.substring(root.length());
        }
        if ((folder = folder.replaceAll("\\\\", JAR_FILE_SEPERATOR)).length() > 0 && folder.charAt(0) == '/') {
            folder = folder.substring(1);
        }
        return folder;
    }
}

