/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.common.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang.LocaleUtils;
import org.eclipse.jubula.autagent.common.commands.AbstractStartToolkitAut;
import org.eclipse.jubula.autagent.common.utils.AutStartHelperRegister;
import org.eclipse.jubula.autagent.common.utils.IAUTStartHelper;
import org.eclipse.jubula.communication.internal.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.internal.jarutils.MainClassLocator;
import org.eclipse.jubula.tools.internal.utils.MonitoringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartJavaAut
extends AbstractStartToolkitAut {
    protected static final String JAVA_OPTIONS_INTRO = "_JAVA_OPTIONS=";
    private static final String JAVA_LANGUAGE_PROPERTY = "-Duser.language=";
    private static final String JAVA_COUNTRY_PROPERTY = "-Duser.country=";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStartJavaAut.class);

    @Override
    protected String createBaseCmd(Map<String, String> parameters) throws IOException {
        String executableFileName = parameters.get("EXECUTABLE");
        if (executableFileName != null && executableFileName.length() > 0) {
            File exe = new File(executableFileName);
            if (!exe.isAbsolute()) {
                exe = new File(parameters.get("WORKING_DIR"), executableFileName);
            }
            if (exe.isFile() && exe.exists()) {
                return exe.getCanonicalPath();
            }
            String errorMsg = String.valueOf(executableFileName) + " does not point to a valid executable.";
            LOG.warn(errorMsg);
            return executableFileName;
        }
        String java = "";
        String jre = parameters.get("JRE_BINARY");
        if (jre == null) {
            jre = "";
        }
        File jreFile = new File(jre);
        if (jre.length() == 0) {
            java = "java";
        } else {
            if (!jreFile.isAbsolute()) {
                jreFile = new File(this.getWorkingDir(parameters), jre);
            }
            if (jreFile.isFile() && jreFile.exists()) {
                java = jreFile.getCanonicalPath();
            } else {
                String errorMsg = jreFile + " does not point to a valid JRE executable.";
                LOG.error(errorMsg);
                throw new FileNotFoundException(errorMsg);
            }
        }
        return java;
    }

    protected String getAUTMainClass(Map parameters) {
        String jarFile = (String)parameters.get("JAR_FILE");
        String mainClass = this.getMainClassFromManifest(parameters);
        if (mainClass != null) {
            return mainClass;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("neither main class transmitted nor found in the manifest, searching in jar: '" + String.valueOf(jarFile) + "'");
        }
        if (jarFile != null && jarFile.length() > 0) {
            List mains;
            block9: {
                block8: {
                    mains = MainClassLocator.getMainClass((File)new File(jarFile));
                    if (mains.size() != 0) break block8;
                    String message = "no main class found in '" + jarFile + "'";
                    LOG.error(message);
                    this.setErrorMessage(new StartAUTServerStateMessage(6, message));
                    return null;
                }
                if (mains.size() == 1) break block9;
                String message = "more than on main class found";
                LOG.error(message);
                this.setErrorMessage(new StartAUTServerStateMessage(7, message));
                return null;
            }
            try {
                return ((String)mains.get(0)).replace('/', '.');
            }
            catch (NullPointerException npe) {
                String message = "no jar given as classpath";
                LOG.error(message, (Throwable)npe);
                this.setErrorMessage(new StartAUTServerStateMessage(8, message));
                return null;
            }
            catch (IOException ioe) {
                String message = "scanning '" + String.valueOf(jarFile) + "' for main class failed";
                LOG.error(message, (Throwable)ioe);
                this.setErrorMessage(new StartAUTServerStateMessage(9, message));
                return null;
            }
        }
        return null;
    }

    protected String getMainClassFromManifest(Map parameters) {
        String jarFile = this.createAbsoluteJarPath(parameters);
        return this.getAttributeFromManifest("main-class", jarFile);
    }

    protected String getAttributeFromManifest(String attributeName, String jarFile) {
        if (jarFile == null || jarFile.length() < 1) {
            return null;
        }
        String attribute = null;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (JarFile jar = new JarFile(jarFile);){
                Manifest manifest = jar.getManifest();
                if (manifest != null) {
                    attribute = manifest.getMainAttributes().getValue(attributeName);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("File not found: " + jarFile, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error reading jar file: " + jarFile, (Throwable)e);
        }
        return attribute;
    }

    protected String createAbsoluteJarPath(Map parameters) {
        File jarFile;
        File workingDir = this.getWorkingDir(parameters);
        String jarPath = (String)parameters.get("JAR_FILE");
        if (jarPath != null && jarPath.length() > 0 && workingDir != null && !(jarFile = new File(jarPath)).isAbsolute()) {
            jarPath = workingDir + FILE_SEPARATOR + jarPath;
        }
        return jarPath;
    }

    protected abstract String getServerClassName();

    protected void addLocale(List<String> cmds, Locale locale) {
        if (locale != null) {
            String language;
            String country = locale.getCountry();
            if (country != null && country.length() > 0) {
                cmds.add(JAVA_COUNTRY_PROPERTY + country);
            }
            if ((language = locale.getLanguage()) != null && language.length() > 0) {
                cmds.add(JAVA_LANGUAGE_PROPERTY + language);
            }
        }
    }

    protected String getClassPathFromManifest(Map parameters) {
        String jarFile = this.createAbsoluteJarPath(parameters);
        String classPath = this.getAttributeFromManifest("class-path", jarFile);
        if (classPath == null) {
            return "";
        }
        classPath = classPath.trim();
        return classPath.replace(' ', PATH_SEPARATOR.charAt(0));
    }

    protected boolean isRunningFromExecutable(Map parameters) {
        return parameters.containsKey("EXECUTABLE");
    }

    protected String setJavaOptions(Map<String, String> parameters) {
        String monAgent;
        StringBuffer sb = new StringBuffer();
        if (this.isRunningFromExecutable(parameters)) {
            String monAgent2;
            Locale locale = LocaleUtils.toLocale((String)parameters.get("AUT_LOCALE"));
            sb.append(JAVA_OPTIONS_INTRO);
            if (MonitoringUtil.shouldAndCanRunWithMonitoring(parameters) && (monAgent2 = this.getMonitoringAgent(parameters)) != null) {
                sb.append(monAgent2).append(" ");
            }
            sb.append("\"").append("-javaagent:").append(this.getAbsoluteAgentJarPath()).append("\"");
            if (locale != null) {
                sb.append(" ").append(JAVA_COUNTRY_PROPERTY).append(locale.getCountry());
                sb.append(" ").append(JAVA_LANGUAGE_PROPERTY).append(locale.getLanguage());
            }
        } else if (MonitoringUtil.shouldAndCanRunWithMonitoring(parameters) && (monAgent = this.getMonitoringAgent(parameters)) != null) {
            sb.append(JAVA_OPTIONS_INTRO).append(monAgent);
        }
        return sb.toString();
    }

    protected String getAbsoluteAgentJarPath() {
        return AbstractStartToolkitAut.getClasspathForBundleId("org.eclipse.jubula.rc.common.agent");
    }

    public static File getInstallDir() {
        IAUTStartHelper helper = AutStartHelperRegister.INSTANCE.getAutStartHelper();
        if (helper == null) {
            LOG.error("No AUTStartHelper registered");
            return null;
        }
        return helper.getInstallationDirectory();
    }

    protected String getMonitoringAgent(Map<String, String> parameters) {
        IAUTStartHelper helper = AutStartHelperRegister.INSTANCE.getAutStartHelper();
        if (helper == null) {
            LOG.error("No AUTStartHelper registered");
            return null;
        }
        return helper.getMonitoringAgent(parameters);
    }
}

