/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.toolkit.ui.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.toolkit.ui.utils.ComponentActionPair;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.utils.generator.CompSystemProcessor;
import org.eclipse.jubula.tools.internal.utils.generator.ComponentInfo;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitInfo;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.swt.widgets.DirectoryDialog;

public class ExportActionsHandler
extends AbstractHandler {
    protected Object executeImpl(ExecutionEvent event) {
        DirectoryDialog dialog = new DirectoryDialog(this.getActiveShell());
        dialog.setFilterPath(Utils.getLastDirPath());
        String targetDir = dialog.open();
        if (targetDir != null) {
            Utils.storeLastDirPath((String)dialog.getFilterPath());
            CompSystemProcessor processor = new CompSystemProcessor(ComponentBuilder.getInstance().getCompSystem());
            List toolkitInfos = processor.getToolkitInfos();
            for (ToolkitInfo tkInfo : toolkitInfos) {
                TreeSet<ComponentActionPair> list = new TreeSet<ComponentActionPair>();
                String tkName = tkInfo.getShortType();
                List compInfos = processor.getCompInfos(tkInfo.getType(), tkName);
                for (ComponentInfo compInfo : compInfos) {
                    Component component = compInfo.getComponent();
                    if (!component.isConcrete() || ((ConcreteComponent)component).getTesterClass() == null) continue;
                    for (Action action : component.getActions()) {
                        list.add(new ComponentActionPair(((ConcreteComponent)component).getComponentClass().getName(), CompSystemI18n.getString((String)action.getName())));
                    }
                }
                ExportActionsHandler.writeListToFile(targetDir, list, tkName);
            }
        }
        return null;
    }

    private static void writeListToFile(String dirPath, SortedSet<ComponentActionPair> list, String tkName) {
        StringBuffer content = new StringBuffer();
        for (ComponentActionPair pair : list) {
            content.append(String.valueOf(pair.toString()) + "\n");
        }
        File dir = new File(dirPath);
        File file = new File(String.valueOf(dirPath) + "/" + tkName.toLowerCase() + "_expectedCAPs.txt");
        ExportActionsHandler.createFile(dir, file, content.toString());
    }

    private static void createFile(File dir, File file, String content) {
        try {
            dir.mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Throwable e = null;
            Object var4_7 = null;
            try (FileOutputStream fop = new FileOutputStream(file);){
                byte[] contentInBytes = content.getBytes();
                IOUtils.write((byte[])contentInBytes, (OutputStream)fop);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

