/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.TestCaseTreeDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractRefactorHandler
extends AbstractSelectionBasedHandler {
    private String m_newTCName = null;
    private INodePO m_selectedCategory = null;

    private String getSuggestedName(AbstractTestCaseEditor editor) {
        String execName;
        Object e;
        String newName = "New Test Case";
        IStructuredSelection cs = (IStructuredSelection)editor.getTreeViewer().getSelection();
        if (cs.size() == 1 && (e = cs.getFirstElement()) instanceof IExecTestCasePO && !StringUtils.isBlank((String)(execName = ((IExecTestCasePO)e).getName()))) {
            newName = execName;
        }
        return newName;
    }

    public static void registerParamNamesToSave(ISpecTestCasePO newSpecTc, ParamNameBPDecorator mapper) {
        for (IParamDescriptionPO desc : newSpecTc.getParameterList()) {
            mapper.registerParamDescriptions((ITcParamDescriptionPO)desc);
        }
    }

    protected boolean askNewNameAndCategory(AbstractTestCaseEditor editor) {
        TestCaseTreeDialog dialog = new TestCaseTreeDialog(this.getActiveShell(), Messages.SelectCategoryDialogTitle, Messages.SelectCategoryDialogMessage, null, Messages.SelectCategoryDialogTitle, 4, IconConstants.OPEN_TC_DIALOG_IMAGE);
        dialog.setReuseds(false);
        dialog.setOnlyCategories(true);
        dialog.setEnterTextLabel(Messages.RefactorTCOptTextLabel, this.getSuggestedName(editor));
        dialog.setPreSelect(GeneralStorage.getInstance().getProject().getSpecObjCont());
        dialog.open();
        if (dialog.getReturnCode() != 0 || dialog.getSelection().isEmpty()) {
            return false;
        }
        this.m_newTCName = dialog.getEnteredText();
        this.m_selectedCategory = dialog.getSelection().get(0);
        return this.m_newTCName != null && this.m_selectedCategory != null;
    }

    protected String getNewTCName() {
        return this.m_newTCName;
    }

    protected INodePO getCategory() {
        return this.m_selectedCategory;
    }

    protected boolean prepareForRefactoring(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(activePart instanceof AbstractTestCaseEditor)) {
            return false;
        }
        AbstractTestCaseEditor editor = (AbstractTestCaseEditor)activePart;
        if (editor.isDirty()) {
            Dialog editorDirtyDlg = ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.Q_SAVE_AND_EXTRACT);
            if (editorDirtyDlg.getReturnCode() != 0) {
                return false;
            }
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        return true;
    }
}

