/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.open;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ShowClientLogBP;
import org.eclipse.jubula.client.ui.rcp.editors.ClientLogInput;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ShowClientLogHandler
extends AbstractHandler {
    private IEditorInput m_clientLogInput = null;

    public Object execute(ExecutionEvent event) {
        File clientLogFile = ShowClientLogBP.getInstance().getClientLogFile();
        if (clientLogFile != null && clientLogFile.canRead()) {
            IWorkbenchPage currentPage = Plugin.getActivePage();
            if (currentPage != null) {
                if (this.m_clientLogInput != null && currentPage.findEditor(this.m_clientLogInput) != null) {
                    currentPage.closeEditor(currentPage.findEditor(this.m_clientLogInput), false);
                }
                this.m_clientLogInput = new ClientLogInput(clientLogFile);
                try {
                    currentPage.openEditor(this.m_clientLogInput, "org.eclipse.jubula.client.ui.rcp.editors.LogViewer");
                }
                catch (PartInitException partInitException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_CANNOT_OPEN_EDITOR);
                }
            }
        } else {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NO_CLIENT_LOG_FOUND);
        }
        return null;
    }
}

